/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.rest;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.replication.ReplicationEnableException;
import com.sonatype.nexus.replication.ReplicationTargetService;
import com.sonatype.nexus.replication.rest.ReplicationTargetApiResourceDoc;
import com.sonatype.nexus.replication.rest.model.ReplicationEnableXO;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.ValidationErrorsException;

@Named
@Singleton
@Path(value="/beta/replicationtarget")
public class ReplicationTargetApiResource
extends ComponentSupport
implements Resource,
ReplicationTargetApiResourceDoc {
    public static final String RESOURCE_URI = "/beta/replicationtarget";
    private final ReplicationTargetService replicationTargetService;

    @Inject
    public ReplicationTargetApiResource(ReplicationTargetService replicationTargetService) {
        this.replicationTargetService = (ReplicationTargetService)Preconditions.checkNotNull((Object)replicationTargetService);
    }

    @Override
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:replication:update"})
    @PUT
    @Path(value="repository/enable")
    @Consumes(value={"application/json"})
    public void enable(ReplicationEnableXO replicationEnableXO) {
        try {
            this.replicationTargetService.enable(replicationEnableXO.getTargetRepositoryName(), replicationEnableXO.getReplicationConnectionName(), replicationEnableXO.getSourceRepositoryName());
        }
        catch (ReplicationEnableException e) {
            throw new ValidationErrorsException().withError("repositoryName", e.getMessage());
        }
    }

    @Override
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:replication:update"})
    @DELETE
    @Path(value="repository/{repositoryName}/enable")
    public void disable(@PathParam(value="repositoryName") String repositoryName) {
        try {
            this.replicationTargetService.disable(repositoryName);
        }
        catch (ReplicationEnableException e) {
            throw new ValidationErrorsException().withError("repositoryName", e.getMessage());
        }
    }
}

