/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.rest;

import com.sonatype.nexus.replication.rest.model.ReplicationConnectionXO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.validation.Valid;
import javax.ws.rs.core.Response;

@Api(value="Replication")
public interface ReplicationApiResourceDoc {
    @ApiOperation(value="Create a replication connection.")
    @ApiResponses(value={@ApiResponse(code=200, message="Replication connection created"), @ApiResponse(code=400, message="Bad request"), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="Insufficient permissions")})
    public ReplicationConnectionXO create(@Valid ReplicationConnectionXO var1);

    @ApiOperation(value="Update a replication connection.")
    @ApiResponses(value={@ApiResponse(code=204, message="Replication connection updated"), @ApiResponse(code=400, message="Bad request"), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="Insufficient permissions"), @ApiResponse(code=404, message="Replication connection not found")})
    public Response update(@ApiParam(value="Replication connection name") String var1, @Valid ReplicationConnectionXO var2);

    @ApiOperation(value="List the replication connections.")
    @ApiResponses(value={@ApiResponse(code=200, message="Replication connection list returned"), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="Insufficient permissions")})
    public List<ReplicationConnectionXO> list();

    @ApiOperation(value="Fetch a replication connection.")
    @ApiResponses(value={@ApiResponse(code=200, message="Replication connection returned"), @ApiResponse(code=400, message="Bad request"), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="Insufficient permissions"), @ApiResponse(code=404, message="Replication connection not found")})
    public ReplicationConnectionXO get(@ApiParam(value="Replication connection name") String var1);

    @ApiOperation(value="Delete a replication connection.")
    @ApiResponses(value={@ApiResponse(code=204, message="Replication connection deleted"), @ApiResponse(code=400, message="Bad request"), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="Insufficient permissions"), @ApiResponse(code=404, message="Replication connection not found")})
    public void delete(@ApiParam(value="Replication connection name") String var1);
}

