/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.rest;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.replication.ReplicationConnectionManager;
import com.sonatype.nexus.replication.ReplicationConnectionValidator;
import com.sonatype.nexus.replication.ReplicationDuplicateException;
import com.sonatype.nexus.replication.TargetInstanceConnector;
import com.sonatype.nexus.replication.db.model.ReplicationConnection;
import com.sonatype.nexus.replication.internal.ReplicationConnectionException;
import com.sonatype.nexus.replication.internal.ReplicationService;
import com.sonatype.nexus.replication.internal.ReplicationUtil;
import com.sonatype.nexus.replication.rest.ReplicationApiResourceDoc;
import com.sonatype.nexus.replication.rest.model.ReplicationConnectionXO;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.rapture.PasswordPlaceholder;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.ValidationErrorsException;
import org.sonatype.nexus.rest.WebApplicationMessageException;
import org.sonatype.nexus.validation.Validate;
import org.sonatype.nexus.validation.group.Create;
import org.sonatype.nexus.validation.group.Update;

@Named
@Singleton
@Path(value="/beta/replication")
public class ReplicationApiResource
extends ComponentSupport
implements Resource,
ReplicationApiResourceDoc {
    public static final String RESOURCE_URI = "/beta/replication";
    private static final String TARGET_DISABLE_WARNING = "Unable to automatically deconfigure replication on the previous target repository. You must manually change this configuration.";
    private final ReplicationConnectionManager replicationConnectionManager;
    private final TargetInstanceConnector targetInstanceConnector;
    private final ReplicationConnectionValidator replicationConnectionValidator;
    private final ReplicationService replicationService;
    private final ReplicationUtil replicationUtil;

    @Inject
    public ReplicationApiResource(ReplicationConnectionManager replicationConnectionManager, TargetInstanceConnector targetInstanceConnector, ReplicationConnectionValidator replicationConnectionValidator, ReplicationService replicationService, ReplicationUtil replicationUtil) {
        this.replicationConnectionManager = (ReplicationConnectionManager)Preconditions.checkNotNull((Object)replicationConnectionManager);
        this.targetInstanceConnector = (TargetInstanceConnector)Preconditions.checkNotNull((Object)targetInstanceConnector);
        this.replicationConnectionValidator = (ReplicationConnectionValidator)((Object)Preconditions.checkNotNull((Object)((Object)replicationConnectionValidator)));
        this.replicationService = (ReplicationService)((Object)Preconditions.checkNotNull((Object)((Object)replicationService)));
        this.replicationUtil = (ReplicationUtil)Preconditions.checkNotNull((Object)replicationUtil);
    }

    @Override
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:replication:create"})
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="connection")
    @Validate(groups={Create.class})
    public ReplicationConnectionXO create(ReplicationConnectionXO replicationConnectionXO) {
        this.checkReplicationEnabled();
        ReplicationConnection replicationConnection = this.toReplicationConnection(replicationConnectionXO);
        replicationConnection.setId(UUID.randomUUID().toString());
        this.replicationConnectionValidator.validate(replicationConnection);
        try {
            this.targetInstanceConnector.enableReplication(replicationConnection);
        }
        catch (ReplicationConnectionException e) {
            throw new ValidationErrorsException().withError("connectionStatus", String.valueOf(e.getStatus())).withError("connectionMessage", e.getMessage());
        }
        try {
            this.replicationConnectionManager.create(replicationConnection);
        }
        catch (ReplicationDuplicateException replicationDuplicateException) {
            this.targetInstanceConnector.disableReplication(replicationConnection);
            throw new ValidationErrorsException("name", "The name \"" + replicationConnection.getName() + "\" is not unique");
        }
        return this.toReplicationConnectionXO(replicationConnection);
    }

    @Override
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:replication:update"})
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="connection/{name}")
    @Validate(groups={Update.class})
    public Response update(@PathParam(value="name") String name, ReplicationConnectionXO replicationConnectionXO) {
        this.checkReplicationEnabled();
        String warningMessage = "";
        ReplicationConnection configuration = this.getReplicationConnectionByName(name);
        if (this.shouldDisablePreviousDestination(configuration, replicationConnectionXO)) {
            try {
                this.targetInstanceConnector.disableReplication(configuration);
            }
            catch (ReplicationConnectionException e) {
                warningMessage = TARGET_DISABLE_WARNING;
                this.log.warn(warningMessage, (Throwable)e);
            }
        }
        configuration.setSourceRepositoryName(replicationConnectionXO.getSourceRepositoryName());
        configuration.setDestinationInstanceUrl(replicationConnectionXO.getDestinationInstanceUrl());
        configuration.setDestinationInstanceUsername(replicationConnectionXO.getDestinationInstanceUsername());
        if (PasswordPlaceholder.isNot((String)replicationConnectionXO.getDestinationInstancePassword())) {
            configuration.setDestinationInstancePassword(replicationConnectionXO.getDestinationInstancePassword());
        }
        configuration.setDestinationRepositoryName(replicationConnectionXO.getDestinationRepositoryName());
        configuration.setContentRegexes(replicationConnectionXO.getContentRegexes());
        configuration.setIncludeExistingContent(replicationConnectionXO.isIncludeExistingContent());
        configuration.setUseTrustStore(replicationConnectionXO.isUseTrustStore());
        this.replicationConnectionValidator.validate(configuration);
        try {
            this.targetInstanceConnector.enableReplication(configuration);
        }
        catch (ReplicationConnectionException e) {
            this.log.error("We were unable to enable replication on the current destination repository.", (Throwable)e);
            throw new ValidationErrorsException().withError("connectionStatus", String.valueOf(e.getStatus())).withError("connectionMessage", e.getMessage());
        }
        this.replicationConnectionManager.update(configuration);
        if (StringUtils.isNotEmpty((String)warningMessage)) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)warningMessage).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    private boolean shouldDisablePreviousDestination(ReplicationConnection previousConfiguration, ReplicationConnectionXO updatedConfiguration) {
        return !previousConfiguration.getDestinationInstanceUrl().equals(updatedConfiguration.getDestinationInstanceUrl()) || !previousConfiguration.getDestinationRepositoryName().equals(updatedConfiguration.getDestinationRepositoryName());
    }

    @Override
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:replication:read"})
    @GET
    @Produces(value={"application/json"})
    @Path(value="connection")
    public List<ReplicationConnectionXO> list() {
        return this.replicationConnectionManager.list().stream().map(this::toReplicationConnectionXO).collect(Collectors.toList());
    }

    @Override
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:replication:read"})
    @GET
    @Produces(value={"application/json"})
    @Path(value="connection/{name}")
    public ReplicationConnectionXO get(@PathParam(value="name") String name) {
        return this.toReplicationConnectionXO(this.replicationConnectionManager.getByName(name).orElseThrow(NotFoundException::new));
    }

    @Override
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:replication:delete"})
    @DELETE
    @Path(value="connection/{name}")
    public void delete(@PathParam(value="name") String name) {
        this.checkReplicationEnabled();
        ReplicationConnection replicationConnection = this.replicationConnectionManager.getByName(name).orElseThrow(NotFoundException::new);
        if (!this.replicationService.deleteConnection(replicationConnection)) {
            throw new NotFoundException();
        }
    }

    private ReplicationConnectionXO toReplicationConnectionXO(ReplicationConnection replicationConnection) {
        ReplicationConnectionXO replicationConnectionXO = new ReplicationConnectionXO();
        replicationConnectionXO.setId(replicationConnection.getId());
        replicationConnectionXO.setName(replicationConnection.getName());
        replicationConnectionXO.setSourceRepositoryName(replicationConnection.getSourceRepositoryName());
        replicationConnectionXO.setDestinationInstanceUrl(replicationConnection.getDestinationInstanceUrl());
        replicationConnectionXO.setDestinationInstanceUsername(replicationConnection.getDestinationInstanceUsername());
        replicationConnectionXO.setDestinationInstancePassword(PasswordPlaceholder.get((String)replicationConnection.getDestinationInstancePassword()));
        replicationConnectionXO.setDestinationRepositoryName(replicationConnection.getDestinationRepositoryName());
        replicationConnectionXO.setContentRegexes(replicationConnection.getContentRegexes());
        replicationConnectionXO.setContentRegexes(replicationConnection.getContentRegexes());
        replicationConnectionXO.setIncludeExistingContent(replicationConnection.isIncludeExistingContent());
        replicationConnectionXO.setUseTrustStore(replicationConnection.isUseTrustStore());
        return replicationConnectionXO;
    }

    private ReplicationConnection toReplicationConnection(ReplicationConnectionXO replicationConnectionXO) {
        ReplicationConnection replicationConnection = this.replicationConnectionManager.newReplicationConnection();
        replicationConnection.setId(replicationConnectionXO.getId());
        replicationConnection.setName(replicationConnectionXO.getName());
        replicationConnection.setSourceRepositoryName(replicationConnectionXO.getSourceRepositoryName());
        replicationConnection.setDestinationInstanceUrl(replicationConnectionXO.getDestinationInstanceUrl());
        replicationConnection.setDestinationInstanceUsername(replicationConnectionXO.getDestinationInstanceUsername());
        if (PasswordPlaceholder.isNot((String)replicationConnection.getDestinationInstancePassword())) {
            replicationConnection.setDestinationInstancePassword(replicationConnectionXO.getDestinationInstancePassword());
        }
        replicationConnection.setDestinationRepositoryName(replicationConnectionXO.getDestinationRepositoryName());
        replicationConnection.setContentRegexes(replicationConnectionXO.getContentRegexes());
        replicationConnection.setIncludeExistingContent(replicationConnectionXO.isIncludeExistingContent());
        replicationConnection.setUseTrustStore(replicationConnectionXO.isUseTrustStore());
        return replicationConnection;
    }

    private ReplicationConnection getReplicationConnectionByName(String name) {
        return this.replicationConnectionManager.getByName(name).orElseThrow(() -> {
            throw new WebApplicationMessageException(Response.Status.NOT_FOUND, "Replication Connection with name=\"" + name + "\" was not found");
        });
    }

    private void checkReplicationEnabled() {
        if (!this.replicationUtil.isReplicationEnabled()) {
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, (Object)"\"Replication not enabled\"", "application/json");
        }
    }
}

