/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.rest;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.replication.rest.model.IngestBlobXO;
import io.swagger.annotations.Api;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.replication.BlobEventType;
import org.sonatype.nexus.repository.replication.ReplicationIngester;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.WebApplicationMessageException;
import org.sonatype.nexus.validation.Validate;
import org.sonatype.nexus.validation.group.Create;

@Named
@Singleton
@Path(value="/beta/ingestresource")
@Api(value="IngestReplication", hidden=true)
public class IngestBlobApiResource
extends ComponentSupport
implements Resource {
    public static final String RESOURCE_URI = "/beta/ingestresource";
    private final RepositoryManager repositoryManager;
    private final Map<String, ReplicationIngester> replicationIngesters;

    @Inject
    public IngestBlobApiResource(RepositoryManager repositoryManager, Map<String, ReplicationIngester> replicationIngesters) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.replicationIngesters = (Map)Preconditions.checkNotNull(replicationIngesters);
    }

    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:replication:create"})
    @POST
    @Consumes(value={"application/json"})
    @Path(value="ingestblob")
    @Validate(groups={Create.class})
    public void ingestBlob(IngestBlobXO ingestBLobXO) {
        Repository repository = this.repositoryManager.get(ingestBLobXO.getRepositoryName());
        if (repository == null) {
            throw new WebApplicationMessageException(Response.Status.NOT_FOUND, (Object)"\"Unable to find repository\"", "application/json");
        }
        ReplicationIngester ingester = this.replicationIngesters.get(repository.getFormat().toString());
        if (ingester == null) {
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, (Object)"\"Format not supported\"", "application/json");
        }
        this.log.debug("Using ingester {}", (Object)ingester);
        ingester.ingestBlob(ingestBLobXO.getBlobIdString(), ingestBLobXO.getBlobStoreId(), ingestBLobXO.getRepositoryName(), BlobEventType.valueOf((String)ingestBLobXO.getEventType()));
    }
}

