/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal.transfer.http.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.exportimport.datastore.ImportAttributesService;
import com.sonatype.nexus.exportimport.model.AssetFileAttributes;
import com.sonatype.nexus.replication.ReplicationTargetService;
import com.sonatype.nexus.replication.internal.pull.source.PullReplicationSourceService;
import com.sonatype.nexus.replication.internal.transfer.http.rest.AssetApiException;
import com.sonatype.nexus.replication.rest.model.HttpPullResponseXO;
import com.sonatype.nexus.replication.rest.model.HttpPushErrorXO;
import com.sonatype.nexus.replication.rest.model.HttpPushRequestXO;
import com.sonatype.nexus.replication.rest.model.HttpPushResponseXO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.ReplicationMarker;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetInfo;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAssets;
import org.sonatype.nexus.repository.content.maintenance.ContentMaintenanceFacet;
import org.sonatype.nexus.repository.importtask.ImportFileConfiguration;
import org.sonatype.nexus.repository.rest.api.RepositoryManagerRESTAdapter;
import org.sonatype.nexus.repository.upload.UploadHandler;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.WebApplicationMessageException;

@Named
@Singleton
@Path(value="/internal/replication")
public class AssetApiResource
extends ComponentSupport
implements Resource {
    private final ReplicationTargetService replicationTargetService;
    private final RepositoryManagerRESTAdapter repositoryManagerRESTAdapter;
    private final ImportAttributesService importAttributesService;
    private final Map<String, UploadHandler> uploadHandlers;
    private final PullReplicationSourceService pullReplicationSourceService;
    public static final String RESOURCE_URI = "/internal/replication";

    @Inject
    public AssetApiResource(ReplicationTargetService replicationTargetService, RepositoryManagerRESTAdapter repositoryManagerRESTAdapter, ImportAttributesService importAttributesService, PullReplicationSourceService pullReplicationSourceService, Map<String, UploadHandler> uploadHandlers) {
        this.replicationTargetService = (ReplicationTargetService)Preconditions.checkNotNull((Object)replicationTargetService);
        this.repositoryManagerRESTAdapter = (RepositoryManagerRESTAdapter)Preconditions.checkNotNull((Object)repositoryManagerRESTAdapter);
        this.importAttributesService = (ImportAttributesService)Preconditions.checkNotNull((Object)importAttributesService);
        this.pullReplicationSourceService = (PullReplicationSourceService)((Object)Preconditions.checkNotNull((Object)((Object)pullReplicationSourceService)));
        this.uploadHandlers = (Map)Preconditions.checkNotNull(uploadHandlers);
    }

    @POST
    @Path(value="replicate")
    @RequiresAuthentication
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"nexus:replication:update"})
    public HttpPushResponseXO replicateAsset(MultipartFormDataInput input) {
        HttpPushResponseXO response = new HttpPushResponseXO();
        try {
            try {
                ReplicationMarker.set((boolean)true);
                HttpPushRequestXO metadata = (HttpPushRequestXO)input.getFormDataPart("metadata", HttpPushRequestXO.class, HttpPushRequestXO.class);
                this.log.debug("Replication Request received: {}", (Object)metadata.type);
                for (String partID : metadata.getPartIDs()) {
                    HttpPushRequestXO.Part partMetadata = metadata.getPartMetadata(partID);
                    this.log.debug("Beginning Replication for part: {}", (Object)partID);
                    if (metadata.type == HttpPushRequestXO.Type.ADD) {
                        this.processPartAdd((InputStream)input.getFormDataPart(partID, InputStream.class, null), partMetadata).ifPresent(ex -> response.addError(partID, ex.getStatus(), ex.getMessage()));
                        continue;
                    }
                    if (metadata.type != HttpPushRequestXO.Type.DELETE) continue;
                    this.processPartDelete(partMetadata).ifPresent(ex -> response.addError(partID, ex.getStatus(), ex.getMessage()));
                }
            }
            catch (IOException ex2) {
                this.log.error("Malformed Replication Request", (Throwable)ex2);
                throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, (Object)("Malformed Replication Request: " + ex2.getMessage()), "application/json");
            }
        }
        finally {
            ReplicationMarker.unset();
        }
        return response;
    }

    @GET
    @Path(value="/{repository}/fetch")
    @Produces(value={"application/json"})
    public HttpPullResponseXO fetchAssets(@PathParam(value="repository") String repositoryName, @Nullable @QueryParam(value="blobCreated") String blobCreated, @QueryParam(value="regexExpression") List<String> regexExpressions) throws AssetApiException {
        Repository repository = this.repositoryManagerRESTAdapter.getRepository(repositoryName);
        OffsetDateTime blobCreatedDate = null;
        if (blobCreated != null) {
            try {
                blobCreatedDate = OffsetDateTime.parse(blobCreated);
            }
            catch (DateTimeParseException dateTimeParseException) {
                throw new AssetApiException(Response.Status.BAD_REQUEST, "blobCreated param is not an offset date time");
            }
        }
        List<AssetInfo> assets = this.pullReplicationSourceService.fetchAssets(repository, blobCreatedDate, regexExpressions);
        HttpPullResponseXO response = new HttpPullResponseXO();
        if (!assets.isEmpty()) {
            AssetInfo lastAsset = assets.get(assets.size() - 1);
            response.setBlobCreated(Date.from(lastAsset.blobCreated().toInstant()));
        }
        response.setAssetPaths(assets.stream().map(AssetInfo::path).collect(Collectors.toList()));
        return response;
    }

    private Optional<HttpPushErrorXO> processPartAdd(InputStream partStream, HttpPushRequestXO.Part partMetadata) {
        AssetFileAttributes assetFileAttributes = partMetadata.getAttributes();
        String repositoryName = partMetadata.getRepository();
        String format = partMetadata.getFormat();
        String assetName = partMetadata.getAssetName();
        this.log.debug("Processing Replication: Repository = {}, Format = {}, Asset = {}", new Object[]{repositoryName, format, assetName});
        try {
            Repository repository = this.getValidatedRepository(repositoryName, format);
            UploadHandler uploadHandler = this.getValidatedUploadHandler(repository.getFormat().toString());
            File tempAssetData = this.copyPartDataToFile(partStream);
            ImportFileConfiguration importFileConfiguration = new ImportFileConfiguration(repository, tempAssetData, assetName);
            this.replicateAsset(repository, uploadHandler, importFileConfiguration, assetFileAttributes);
        }
        catch (AssetApiException ex) {
            return Optional.of(new HttpPushErrorXO(ex.getStatus(), ex.getMessage()));
        }
        return Optional.empty();
    }

    private Optional<HttpPushErrorXO> processPartDelete(HttpPushRequestXO.Part partMetadata) {
        String repositoryName = partMetadata.getRepository();
        String format = partMetadata.getFormat();
        String assetName = partMetadata.getAssetName();
        this.log.debug("Processing Replication Delete: Repository = {}, Format = {}, Asset = {}", new Object[]{repositoryName, format, assetName});
        try {
            Repository repository = this.getValidatedRepository(repositoryName, format);
            return this.replicateDelete(repository, assetName);
        }
        catch (AssetApiException ex) {
            return Optional.of(new HttpPushErrorXO(ex.getStatus(), ex.getMessage()));
        }
    }

    @VisibleForTesting
    Repository getValidatedRepository(String repositoryName, String format) throws AssetApiException {
        Repository repository = this.repositoryManagerRESTAdapter.getRepository(repositoryName);
        if (format == null || !repository.getFormat().getValue().equals(format)) {
            this.log.warn("Unable to Replicate asset - Repository {} is not for the expected format {}", (Object)repositoryName, (Object)format);
            throw new AssetApiException(Response.Status.BAD_REQUEST, String.format("Replication format [%s] must match Repository format [%s].", format, repository.getFormat().getValue()));
        }
        if (!this.replicationTargetService.isReplicationEnabled(repository)) {
            this.log.warn("Unable to Replicate asset - Repository {} is not enabled for replication", (Object)repositoryName);
            throw new AssetApiException(Response.Status.BAD_REQUEST, "Replication Target Repository is not enabled for replication: " + repositoryName);
        }
        return repository;
    }

    @VisibleForTesting
    UploadHandler getValidatedUploadHandler(String repositoryFormat) throws AssetApiException {
        UploadHandler uploadHandler = this.uploadHandlers.get(repositoryFormat);
        if (uploadHandler == null) {
            this.log.warn("Unable to Replicate asset format {} - No handler available", (Object)repositoryFormat);
            throw new AssetApiException(Response.Status.NOT_IMPLEMENTED, String.format("Format %s is not supported for Replication", repositoryFormat));
        }
        return uploadHandler;
    }

    @VisibleForTesting
    File copyPartDataToFile(InputStream partStream) throws AssetApiException {
        File tempData;
        try {
            tempData = File.createTempFile("replicationIngest-", "");
            this.log.debug("Replication temporary file: {}", (Object)tempData.toPath().getFileName());
            Files.copy(partStream, tempData.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ex) {
            this.log.error("Failed to write temporary Replication asset data.", (Throwable)ex);
            throw new AssetApiException(Response.Status.INTERNAL_SERVER_ERROR, "Failed to write temporary asset Data");
        }
        return tempData;
    }

    @VisibleForTesting
    void replicateAsset(Repository repository, UploadHandler uploadHandler, ImportFileConfiguration importFileConfiguration, AssetFileAttributes assetFileAttributes) throws AssetApiException {
        try {
            try {
                uploadHandler.handle(importFileConfiguration);
                ContentFacet contentFacet = (ContentFacet)importFileConfiguration.getRepository().facet(ContentFacet.class);
                contentFacet.assets().path(importFileConfiguration.getAssetName()).find().ifPresent(asset -> this.importAttributesService.importAttributes(assetFileAttributes, null, (Asset)asset, repository));
                this.log.debug("Completed Replication for asset {} in Repository {}", (Object)importFileConfiguration.getAssetName(), (Object)importFileConfiguration.getRepository().getName());
            }
            catch (IOException ex) {
                this.log.error("Failed to Replicate Asset", (Throwable)ex);
                throw new AssetApiException(Response.Status.INTERNAL_SERVER_ERROR, "Failed to store asset data");
            }
        }
        finally {
            File tempAssetData = importFileConfiguration.getFile();
            if (tempAssetData != null && tempAssetData.exists()) {
                try {
                    Files.delete(tempAssetData.toPath());
                }
                catch (Exception ex) {
                    this.log.warn("Failed to clean up temporary storage {}", (Object)tempAssetData.getName());
                    this.log.debug("Deletion Exception:", (Throwable)ex);
                    tempAssetData.deleteOnExit();
                }
            }
        }
    }

    private Optional<HttpPushErrorXO> replicateDelete(Repository repository, String assetName) {
        FluentAssets assets = ((ContentFacet)repository.facet(ContentFacet.class)).assets();
        ContentMaintenanceFacet componentMaintenance = (ContentMaintenanceFacet)repository.facet(ContentMaintenanceFacet.class);
        Optional result = assets.path(assetName).find();
        if (result.isPresent()) {
            componentMaintenance.deleteAsset((Asset)result.get());
        } else {
            this.log.warn("Unable to find asset to delete with path " + assetName);
        }
        return Optional.empty();
    }
}

