/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal.tasks.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.sonatype.nexus.replication.ReplicationConnectionManager;
import com.sonatype.nexus.replication.ReplicationQueueManager;
import com.sonatype.nexus.replication.internal.tasks.ReplicationBackfillQueueService;
import com.sonatype.nexus.replication.internal.tasks.ReplicationBackfillQueueServiceSupport;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.orient.entity.AttachedEntityHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.AssetStore;
import org.sonatype.nexus.repository.storage.BucketStore;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;

@Singleton
@Named
public class OrientReplicationBackfillQueueServiceImpl
extends ReplicationBackfillQueueServiceSupport
implements ReplicationBackfillQueueService {
    private final AssetStore assetStore;
    private final BucketStore bucketStore;

    @Inject
    public OrientReplicationBackfillQueueServiceImpl(RepositoryManager repositoryManager, AssetStore assetStore, BucketStore bucketStore, ReplicationQueueManager replicationQueueManager, ReplicationConnectionManager replicationConnectionManager, @Named(value="${nexus.replication.queue.backfill.pageSize:-1000}") int pageSize) {
        super(repositoryManager, replicationQueueManager, replicationConnectionManager, pageSize);
        this.assetStore = (AssetStore)Preconditions.checkNotNull((Object)assetStore);
        this.bucketStore = (BucketStore)Preconditions.checkNotNull((Object)bucketStore);
    }

    @Override
    protected void doBackfill(Repository repository, String replicationConnectionId, BooleanSupplier shouldStopFunction) {
        ORID bucketId = AttachedEntityHelper.id((Entity)this.bucketStore.read(repository.getName()));
        OIndexCursor cursor = this.assetStore.getIndex(AssetEntityAdapter.I_BUCKET_COMPONENT_NAME).cursor();
        List nextPage = this.assetStore.getNextPage(cursor, this.getPageSize());
        while (!Iterables.isEmpty((Iterable)nextPage)) {
            if (!this.walkPage(nextPage, repository, replicationConnectionId, bucketId, shouldStopFunction)) break;
            nextPage = this.assetStore.getNextPage(cursor, this.getPageSize());
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean walkPage(List<Map.Entry<OCompositeKey, EntityId>> page, Repository repository, String replicationConnectionId, ORID bucketId, BooleanSupplier shouldStopFunction) {
        var6_6 = null;
        var7_8 = null;
        try {
            storageTx = (StorageTx)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier().get();
            try {
                storageTx.begin();
                var10_11 = page.iterator();
                while (true) {
                    indexEntry = var10_11.next();
                    if (shouldStopFunction.getAsBoolean()) {
                        this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Task cancelled, stopping processing");
                        return false;
                    }
                    if (!bucketId.equals(indexEntry.getKey().getKeys().get(0))) {
                        this.log.trace(TaskLoggingMarkers.TASK_LOG_ONLY, "Skipping {} as it does not belong to the repository bucket", (Object)indexEntry.getValue());
                    }
                    asset = this.assetStore.getById(indexEntry.getValue());
                    if (asset == null) {
                        this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Skipping assetId {} as it was not found in the database", (Object)indexEntry.getValue());
                    }
                    this.backfillAsset(asset, repository, replicationConnectionId);
                    break;
                }
            }
            finally {
                if (var10_11.hasNext()) ** continue;
                return true;
            }
        }
        catch (Throwable var7_9) {
            if (var6_6 == null) {
                var6_6 = var7_9;
                throw var6_6;
            }
            if (var6_6 == var7_9) throw var6_6;
            var6_6.addSuppressed(var7_9);
            throw var6_6;
        }
    }

    private void backfillAsset(Asset asset, Repository repository, String replicationConnectionId) {
        BlobRef blobRef = asset.blobRef();
        if (blobRef == null) {
            this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Skipping asset {} as it has no blob backing it.", (Object)asset.name());
        } else {
            this.backfillAsset(repository.getName(), replicationConnectionId, asset.name(), blobRef.getBlob());
        }
    }
}

