/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal.tasks;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.replication.ReplicationConnectionManager;
import com.sonatype.nexus.replication.ReplicationQueueManager;
import com.sonatype.nexus.replication.db.model.ReplicationConnection;
import com.sonatype.nexus.replication.internal.tasks.ReplicationBackfillQueueService;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.replication.BlobEvent;
import org.sonatype.nexus.repository.replication.BlobEventType;

public abstract class ReplicationBackfillQueueServiceSupport
extends ComponentSupport
implements ReplicationBackfillQueueService {
    private final RepositoryManager repositoryManager;
    private final ReplicationQueueManager replicationQueueManager;
    private final ReplicationConnectionManager replicationConnectionManager;
    private final int pageSize;

    protected ReplicationBackfillQueueServiceSupport(RepositoryManager repositoryManager, ReplicationQueueManager replicationQueueManager, ReplicationConnectionManager replicationConnectionManager, int pageSize) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.replicationQueueManager = (ReplicationQueueManager)Preconditions.checkNotNull((Object)replicationQueueManager);
        this.replicationConnectionManager = (ReplicationConnectionManager)Preconditions.checkNotNull((Object)replicationConnectionManager);
        this.pageSize = pageSize;
    }

    @Override
    public void backfill(String repositoryName, BooleanSupplier shouldStopFunction) {
        Repository repository = this.repositoryManager.get(repositoryName);
        if (repository == null) {
            this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Repository {} not found, backfill stopping.", (Object)repositoryName);
        } else {
            List<ReplicationConnection> replicationConnections = this.replicationConnectionManager.list().stream().filter(rc -> rc.getSourceRepositoryName().equals(repository.getName())).collect(Collectors.toList());
            if (replicationConnections.isEmpty()) {
                this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Replication Connection not found for repository {}, backfill stopping.", (Object)repository);
            } else {
                replicationConnections.forEach(replicationConnection -> {
                    this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Repository {} in Replication Connection {} will be backfilled into the replication queue.", (Object)repositoryName, (Object)replicationConnection.getName());
                    this.doBackfill(repository, replicationConnection.getId(), shouldStopFunction);
                });
            }
        }
    }

    @Override
    public void backfillByReplicationConnection(String replicationConnectionId, BooleanSupplier shouldStopFunction) {
        ReplicationConnection replicationConnection = this.replicationConnectionManager.getById(replicationConnectionId).orElse(null);
        if (replicationConnection == null) {
            this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Replication Connection not found for id {}, backfill stopping.", (Object)replicationConnectionId);
            return;
        }
        if (this.repositoryManager.get(replicationConnection.getSourceRepositoryName()) == null) {
            this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Repository {} not found, backfill stopping.", (Object)replicationConnection.getSourceRepositoryName());
        } else {
            this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Repository {} in Replication Connection {} will be backfilled into the replication queue.", (Object)replicationConnection.getSourceRepositoryName(), (Object)replicationConnection.getName());
            this.doBackfill(this.repositoryManager.get(replicationConnection.getSourceRepositoryName()), replicationConnection.getId(), shouldStopFunction);
        }
    }

    protected abstract void doBackfill(Repository var1, String var2, BooleanSupplier var3);

    protected void backfillAsset(String repository, String replicationConnectionId, String asset, String blobId) {
        this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Adding asset {} to replication queue for repository {} in replicationConnectionId {}", new Object[]{asset, repository, replicationConnectionId});
        this.replicationQueueManager.addToQueue(replicationConnectionId, new BlobEvent().withBlobEventType(BlobEventType.ADDED).withRepositoryName(repository).withReplicationConnectionId(replicationConnectionId).withAssetPath(asset).withRetryCount(3).withBlobId(blobId));
    }

    protected int getPageSize() {
        return this.pageSize;
    }
}

