/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal.pull.source;

import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.AssetInfo;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.store.AssetStore;

@Named
public class PullReplicationSourceService
extends ComponentSupport {
    private final int batchSize;

    @Inject
    public PullReplicationSourceService(@Named(value="${nexus.replication.pull.batchSize:-50}") int batchSize) {
        this.batchSize = batchSize;
    }

    public List<AssetInfo> fetchAssets(Repository repository, @Nullable OffsetDateTime blobCreated, List<String> regexExpressions) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(regexExpressions);
        ContentFacetSupport contentFacet = (ContentFacetSupport)repository.facet(ContentFacet.class);
        AssetStore assetStore = contentFacet.stores().assetStore;
        return assetStore.findUpdatedAssets(contentFacet.contentRepositoryId().intValue(), blobCreated, regexExpressions, this.batchSize);
    }
}

