/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal.pull;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sonatype.nexus.replication.internal.pull.SourceConnection;
import com.sonatype.nexus.replication.internal.pull.SourceUnavailableException;
import com.sonatype.nexus.replication.rest.model.HttpPullResponseXO;
import java.io.IOException;
import java.time.OffsetDateTime;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.httpclient.HttpClientManager;
import org.sonatype.nexus.httpclient.HttpClientPlan;
import org.sonatype.nexus.httpclient.PreemptiveAuthHttpRequestInterceptor;
import org.sonatype.nexus.httpclient.config.AuthenticationConfiguration;
import org.sonatype.nexus.httpclient.config.ConfigurationCustomizer;
import org.sonatype.nexus.httpclient.config.ConnectionConfiguration;
import org.sonatype.nexus.httpclient.config.HttpClientConfiguration;
import org.sonatype.nexus.httpclient.config.UsernameAuthenticationConfiguration;

@Named
public class SourceInstanceConnector
extends ComponentSupport {
    ObjectMapper objectMapper = new ObjectMapper();
    private final HttpClientManager httpClientManager;

    @Inject
    public SourceInstanceConnector(HttpClientManager httpClientManager) {
        this.httpClientManager = httpClientManager;
    }

    public HttpPullResponseXO fetchAssets(SourceConnection sourceConnection, @Nullable OffsetDateTime blobCreated) throws SourceUnavailableException {
        String url = String.valueOf(sourceConnection.getBaseUrl()) + "/service/rest/internal/replication/" + sourceConnection.getRepositoryName() + "/fetch";
        if (blobCreated != null) {
            url = String.valueOf(url) + "?blobCreated=" + blobCreated;
        }
        HttpGet request = new HttpGet(url);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (CloseableHttpClient client = this.createHttpClient(sourceConnection);){
                CloseableHttpResponse response = client.execute((HttpUriRequest)request);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    return (HttpPullResponseXO)this.objectMapper.readValue(response.getEntity().getContent(), HttpPullResponseXO.class);
                }
                throw new HttpResponseException(statusCode, response.getStatusLine().getReasonPhrase());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new SourceUnavailableException("Unable to fetch list of assets", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validateSuitableRemote(SourceConnection sourceConnection) {
        String url = String.valueOf(sourceConnection.getBaseUrl()) + "/service/rest/repository/browse/" + sourceConnection.getRepositoryName() + "/";
        HttpGet request = new HttpGet(url);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (CloseableHttpClient client = this.createHttpClient(sourceConnection);){
                CloseableHttpResponse response = client.execute((HttpUriRequest)request);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) return false;
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            this.log.warn("Unable to verify proxy remote endpoint: {}", (Object)e.getMessage());
            if (!this.log.isTraceEnabled()) return false;
            this.log.trace("Stack trace:", (Throwable)e);
        }
        return false;
    }

    private CloseableHttpClient createHttpClient(SourceConnection sourceConnection) {
        HttpClientConfiguration configuration = this.httpClientManager.newConfiguration();
        sourceConnection.getUsername().ifPresent(username -> {
            UsernameAuthenticationConfiguration authentication = new UsernameAuthenticationConfiguration();
            authentication.setUsername(username);
            authentication.setPassword(sourceConnection.getPassword().orElseThrow(() -> new RuntimeException("No password specified in source connection")));
            configuration.setAuthentication((AuthenticationConfiguration)authentication);
        });
        ConnectionConfiguration connection = new ConnectionConfiguration();
        if (sourceConnection.getTimeoutSeconds() != null) {
            connection.setTimeout(Time.seconds((long)sourceConnection.getTimeoutSeconds().intValue()));
        }
        connection.setUseTrustStore(Boolean.valueOf(sourceConnection.isUseTrustStore()));
        configuration.setConnection(connection);
        return this.httpClientManager.create((HttpClientPlan.Customizer)new ConfigurationCustomizer(configuration){

            public void customize(HttpClientPlan plan) {
                super.customize(plan);
                plan.getClient().useSystemProperties();
                plan.getClient().addInterceptorFirst((HttpRequestInterceptor)new PreemptiveAuthHttpRequestInterceptor());
            }
        });
    }
}

