/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal.pull;

import java.util.Optional;
import javax.annotation.Nullable;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.view.Response;

public class PullResponse {
    @Nullable
    private final Response response;
    @Nullable
    private final Exception exception;
    private final Repository repository;
    private final String path;

    public PullResponse(Response response, Repository repository, String path) {
        this.response = response;
        this.exception = null;
        this.repository = repository;
        this.path = path;
    }

    public PullResponse(Exception exception, Repository repository, String path) {
        this.exception = exception;
        this.response = null;
        this.repository = repository;
        this.path = path;
    }

    public Optional<Response> getResponse() {
        return Optional.ofNullable(this.response);
    }

    public Optional<Exception> getException() {
        return Optional.ofNullable(this.exception);
    }

    public Repository getRepository() {
        return this.repository;
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        return "PullResponse{response=" + this.response + ", repository=" + this.repository + ", path='" + this.path + '\'' + '}';
    }
}

