/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal.pull;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.manager.RepositoryCreatedEvent;
import org.sonatype.nexus.repository.manager.RepositoryDeletedEvent;
import org.sonatype.nexus.repository.manager.RepositoryUpdatedEvent;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.schedule.Cron;
import org.sonatype.nexus.scheduling.schedule.Schedule;

@Named
@Singleton
public class PullReplicationTaskManager
extends ComponentSupport
implements EventAware,
EventAware.Asynchronous {
    public static final String CRON_TEMPLATE = "%s %s/5 * * * ?";
    private final Random random = new Random();
    private final TaskScheduler taskScheduler;

    @Inject
    public PullReplicationTaskManager(TaskScheduler taskScheduler) {
        this.taskScheduler = Objects.requireNonNull(taskScheduler);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryCreatedEvent event) {
        if (this.pullEnabled(event.getRepository().getConfiguration())) {
            this.maybeCreateTask(event.getRepository().getName());
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryUpdatedEvent event) {
        if (this.pullEnabled(event.getRepository().getConfiguration())) {
            this.maybeCreateTask(event.getRepository().getName());
        } else {
            this.maybeDeleteTask(event.getRepository().getName());
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryDeletedEvent event) {
        this.maybeDeleteTask(event.getRepository().getName());
    }

    private boolean pullEnabled(Configuration config) {
        return (Boolean)config.copy().attributes("replication").get("preemptivePullEnabled", (Object)false);
    }

    private Optional<TaskInfo> getPullTask(List<TaskInfo> tasks, String repositoryName) {
        return tasks.stream().filter(t -> "replication.pull".equals(t.getTypeId()) && repositoryName.equals(t.getConfiguration().getString("repositoryName"))).findFirst();
    }

    private void maybeCreateTask(String repositoryName) {
        if (!this.getPullTask(this.taskScheduler.listsTasks(), repositoryName).isPresent()) {
            this.log.info("Creating pull replication task for {}", (Object)repositoryName);
            TaskConfiguration configuration = this.taskScheduler.createTaskConfigurationInstance("replication.pull");
            configuration.setString("repositoryName", repositoryName);
            configuration.setName("Replicate content: " + repositoryName);
            Cron schedule = this.taskScheduler.getScheduleFactory().cron(new Date(), this.randomCron());
            this.taskScheduler.scheduleTask(configuration, (Schedule)schedule);
        }
    }

    private String randomCron() {
        return String.format(CRON_TEMPLATE, this.random.nextInt(60), this.random.nextInt(5));
    }

    private void maybeDeleteTask(String repositoryName) {
        this.getPullTask(this.taskScheduler.listsTasks(), repositoryName).ifPresent(taskInfo -> {
            this.log.info("Deleting pull replication task for {}", (Object)repositoryName);
            taskInfo.remove();
        });
    }
}

