/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal.pull;

import com.sonatype.nexus.replication.internal.pull.PullReplicationService;
import com.sonatype.nexus.replication.internal.pull.PullResponse;
import com.sonatype.nexus.replication.internal.pull.SourceConnection;
import com.sonatype.nexus.replication.internal.pull.SourceInstanceConnector;
import com.sonatype.nexus.replication.internal.pull.SourceUnavailableException;
import com.sonatype.nexus.replication.rest.model.HttpPullResponseXO;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.shiro.subject.Subject;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryTaskSupport;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.scheduling.TaskInterruptedException;
import org.sonatype.nexus.security.subject.FakeAlmightySubject;
import org.sonatype.nexus.thread.NexusExecutorService;

@Named
public class PullReplicationTask
extends RepositoryTaskSupport
implements Cancelable {
    private final PullReplicationService pullReplicationService;
    private final SourceInstanceConnector sourceInstanceConnector;
    private final ExecutorService executorService;

    @Inject
    public PullReplicationTask(PullReplicationService pullReplicationService, SourceInstanceConnector sourceInstanceConnector, @Named(value="${nexus.replication.pull.threads:-1}") int threads) {
        this.pullReplicationService = pullReplicationService;
        this.sourceInstanceConnector = sourceInstanceConnector;
        this.executorService = NexusExecutorService.forFixedSubject((ExecutorService)Executors.newFixedThreadPool(threads), (Subject)FakeAlmightySubject.TASK_SUBJECT);
    }

    protected void execute(Repository repository) {
        SourceConnection.from(repository).ifPresent(sourceConnection -> {
            HttpPullResponseXO result;
            try {
                result = this.sourceInstanceConnector.fetchAssets((SourceConnection)sourceConnection, this.pullReplicationService.getBlobCreated(repository));
            }
            catch (SourceUnavailableException e2) {
                this.log.error("Pull replication task could not complete because there was an error communicating with the source", (Throwable)e2);
                return;
            }
            ArrayList<Future<PullResponse>> futureResponses = new ArrayList<Future<PullResponse>>();
            for (String string : result.getAssetPaths()) {
                CancelableHelper.checkCancellation();
                futureResponses.add(this.executorService.submit(() -> this.pullReplicationService.pullAsset(repository, path)));
            }
            for (Future future : futureResponses) {
                CancelableHelper.checkCancellation();
                try {
                    PullResponse pullResponse = (PullResponse)future.get();
                    pullResponse.getException().ifPresent(e -> this.log.error("Exception pulling asset " + pullResponse, (Throwable)e));
                    pullResponse.getResponse().ifPresent(response -> {
                        if (!response.getStatus().isSuccessful()) {
                            this.log.error("Error pulling asset {}", response);
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    throw new TaskInterruptedException("Thread '" + Thread.currentThread().getName() + "' is interrupted", false);
                }
                catch (ExecutionException ee) {
                    this.log.error("Unexpected error pulling asset", ee.getCause());
                    if (!(ee.getCause() instanceof Error)) continue;
                    throw (Error)ee.getCause();
                }
            }
            if (result.getBlobCreated() != null) {
                this.pullReplicationService.setBlobCreated(repository, result.getBlobCreated().toInstant().atOffset(ZoneOffset.UTC));
            }
        });
    }

    protected boolean appliesTo(Repository repository) {
        return true;
    }

    public String getMessage() {
        return "Pull Replication";
    }
}

