/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal.pull;

import com.sonatype.nexus.replication.internal.pull.PullResponse;
import java.time.OffsetDateTime;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.ViewFacet;

@Named
public class PullReplicationService
extends ComponentSupport {
    private RepositoryManager repositoryManager;

    @Inject
    public PullReplicationService(RepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    public PullResponse pullAsset(Repository repository, String path) {
        Request request = new Request.Builder().action("GET").path(path).build();
        try {
            Response response = ((ViewFacet)repository.facet(ViewFacet.class)).dispatch(request);
            return new PullResponse(response, repository, path);
        }
        catch (Exception e) {
            return new PullResponse(e, repository, path);
        }
    }

    @Nullable
    public OffsetDateTime getBlobCreated(Repository repository) {
        String blobCreatedValue = (String)repository.getConfiguration().attributes("replication").get("blobCreated", String.class);
        if (blobCreatedValue != null) {
            return OffsetDateTime.parse(blobCreatedValue);
        }
        return null;
    }

    public void setBlobCreated(Repository repository, OffsetDateTime blobCreated) {
        Configuration configuration = repository.getConfiguration().copy();
        configuration.attributes("replication").set("blobCreated", (Object)blobCreated.toString());
        try {
            this.repositoryManager.update(configuration);
        }
        catch (Exception e) {
            this.log.warn("Unable to update blobCreated attribute in repository attributes", (Throwable)e);
        }
    }
}

