/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal.db.orient;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.replication.internal.BlobAttributeBackfillService;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobAttributes;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;

@Named
public class OrientBlobAttributeBackfillService
extends ComponentSupport
implements BlobAttributeBackfillService {
    private final RepositoryManager repositoryManager;
    private final NodeAccess nodeAccess;

    @Inject
    public OrientBlobAttributeBackfillService(RepositoryManager repositoryManager, NodeAccess nodeAccess) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
    }

    @Override
    public void backfillBlobAttributes(BlobStore blobStore, BlobId blobId, BlobAttributes blobAttributes) {
        block10: {
            String repositoryName = this.getRepositoryName(blobAttributes);
            Repository repository = this.repositoryManager.get(repositoryName);
            if (repository != null) {
                Throwable throwable = null;
                Object var7_8 = null;
                try (StorageTx storageTx = (StorageTx)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier().get();){
                    storageTx.begin();
                    this.doBackfillBlobAttributes(storageTx, blobStore, blobId);
                    storageTx.commit();
                    break block10;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            this.log.warn("repository {} referenced by blob {} does not exist.", (Object)repositoryName, (Object)blobId);
        }
    }

    private void doBackfillBlobAttributes(StorageTx storageTx, BlobStore blobStore, BlobId blobId) {
        BlobRef blobRef = new BlobRef(this.nodeAccess.getId(), blobStore.getBlobStoreConfiguration().getName(), blobId.asUniqueString());
        Asset asset = storageTx.findAssetWithProperty("blob_ref", (Object)blobRef.toString());
        if (asset != null) {
            storageTx.attachAssetMetadata(asset, blobId);
        }
    }
}

