/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal.db.orient;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.replication.ReplicationConnectionManager;
import com.sonatype.nexus.replication.ReplicationQueueManager;
import com.sonatype.nexus.replication.internal.ReplicationUtil;
import com.sonatype.nexus.replication.internal.db.AssetEventListenerSupport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.replication.BlobEventType;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetCreatedEvent;
import org.sonatype.nexus.repository.storage.AssetDeletedEvent;
import org.sonatype.nexus.repository.storage.AssetUpdatedEvent;

@Named
@Singleton
public class OrientAssetEventListener
extends AssetEventListenerSupport
implements EventAware {
    @Inject
    public OrientAssetEventListener(ReplicationQueueManager replicationQueueManager, ReplicationConnectionManager replicationConnectionManager, ReplicationUtil replicationUtil) {
        super(replicationConnectionManager, replicationQueueManager, replicationUtil);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(AssetCreatedEvent event) {
        this.addToQueue(BlobEventType.ADDED, event.getRepositoryName(), event.getAsset());
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(AssetUpdatedEvent event) {
        this.addToQueue(BlobEventType.UPDATED, event.getRepositoryName(), event.getAsset());
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(AssetDeletedEvent event) {
        this.addToQueue(BlobEventType.DELETED, event.getRepositoryName(), event.getAsset());
    }

    private void addToQueue(BlobEventType blobEventType, String repositoryName, @Nullable Asset asset) {
        if (this.validate(asset, repositoryName)) {
            if (asset.blobRef() == null) {
                this.log.debug("Found asset with no blobRef, not going to process for replication: {}", (Object)asset.name());
            } else {
                this.addToQueue(asset.requireBlobRef().getBlobId().asUniqueString(), repositoryName, blobEventType, asset.name());
            }
        }
    }
}

