/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal.db.datastore;

import com.sonatype.nexus.replication.ReplicationEventStore;
import com.sonatype.nexus.replication.db.datastore.ReplicationEventDAO;
import com.sonatype.nexus.replication.db.model.ReplicationEvent;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.transaction.Transactional;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@Singleton
public class ReplicationEventStoreImpl
extends ConfigStoreSupport<ReplicationEventDAO>
implements ReplicationEventStore {
    private final int batchSize;

    @Inject
    public ReplicationEventStoreImpl(DataSessionSupplier sessionSupplier, @Named(value="${nexus.replication.http.queue.batchSize:-50}") int batchSize) {
        super(sessionSupplier);
        this.batchSize = batchSize;
    }

    @Override
    @Transactional
    public void create(ReplicationEvent event) {
        ((ReplicationEventDAO)this.dao()).create(event);
    }

    @Override
    @Transactional
    public void update(ReplicationEvent event) {
        ((ReplicationEventDAO)this.dao()).update(event);
    }

    @Override
    @Transactional
    public boolean delete(List<ReplicationEvent> eventList) {
        return ((ReplicationEventDAO)this.dao()).delete(eventList);
    }

    @Override
    @Transactional
    public synchronized List<ReplicationEvent> nextBatch() {
        List<ReplicationEvent> batch = ((ReplicationEventDAO)this.dao()).fetchNextBatch(this.batchSize);
        ((ReplicationEventDAO)this.dao()).markBatchInUse(batch);
        return batch;
    }

    protected void doStart() {
        this.resetInUse();
    }

    @Transactional
    public void resetInUse() {
        ((ReplicationEventDAO)this.dao()).resetInUse();
    }
}

