/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal.db.datastore;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.replication.ReplicationConnectionStore;
import com.sonatype.nexus.replication.ReplicationDuplicateException;
import com.sonatype.nexus.replication.db.datastore.ReplicationConnectionDAO;
import com.sonatype.nexus.replication.db.model.ReplicationConnection;
import com.sonatype.nexus.replication.db.model.ReplicationConnectionImpl;
import com.sonatype.nexus.replication.internal.audit.ReplicationConfigurationCreatedEvent;
import com.sonatype.nexus.replication.internal.audit.ReplicationConfigurationDeletedEvent;
import com.sonatype.nexus.replication.internal.audit.ReplicationConfigurationUpdatedEvent;
import com.sonatype.nexus.replication.internal.tasks.ReplicationBackfillQueueTaskManager;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.datastore.api.DuplicateKeyException;
import org.sonatype.nexus.transaction.Transactional;

@Named
public class ReplicationConnectionStoreImpl
extends ConfigStoreSupport<ReplicationConnectionDAO>
implements ReplicationConnectionStore {
    final ReplicationBackfillQueueTaskManager replicationBackfillQueueTaskManager;
    private final EventManager eventManager;

    @Inject
    public ReplicationConnectionStoreImpl(DataSessionSupplier sessionSupplier, ReplicationBackfillQueueTaskManager replicationBackfillQueueTaskManager, EventManager eventManager) {
        super(sessionSupplier);
        this.replicationBackfillQueueTaskManager = (ReplicationBackfillQueueTaskManager)Preconditions.checkNotNull((Object)replicationBackfillQueueTaskManager);
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
    }

    @Override
    public ReplicationConnection newReplicationConnection() {
        return new ReplicationConnectionImpl();
    }

    @Override
    @Transactional
    public List<ReplicationConnection> list() {
        return new ArrayList<ReplicationConnection>(((ReplicationConnectionDAO)this.dao()).list());
    }

    @Override
    @Transactional
    public void create(ReplicationConnection replicationConnection) throws ReplicationDuplicateException {
        try {
            ((ReplicationConnectionDAO)this.dao()).create(replicationConnection);
        }
        catch (DuplicateKeyException e) {
            throw new ReplicationDuplicateException((Exception)((Object)e));
        }
        if (replicationConnection.isIncludeExistingContent()) {
            this.replicationBackfillQueueTaskManager.backfillRepository(replicationConnection.getSourceRepositoryName());
        }
        this.eventManager.post((Object)new ReplicationConfigurationCreatedEvent(replicationConnection));
    }

    @Override
    @Transactional
    public void update(ReplicationConnection replicationConnection) {
        ((ReplicationConnectionDAO)this.dao()).update(replicationConnection);
        this.eventManager.post((Object)new ReplicationConfigurationUpdatedEvent(replicationConnection));
    }

    @Override
    @Transactional
    public boolean delete(String id) {
        boolean deleteSuccessful = ((ReplicationConnectionDAO)this.dao()).delete(id);
        if (deleteSuccessful) {
            this.eventManager.post((Object)new ReplicationConfigurationDeletedEvent(id));
        }
        return deleteSuccessful;
    }

    @Override
    public void detach(ReplicationConnection con) {
    }
}

