/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal.customizers;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.replication.ReplicationConnectionManager;
import com.sonatype.nexus.replication.db.model.ReplicationConnection;
import com.sonatype.nexus.replication.internal.customizers.ReplicationLogsGenerator;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.api.RawObjectAccess;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.supportzip.SupportBundle;
import org.sonatype.nexus.supportzip.SupportBundleCustomizer;

@Named
@Singleton
public class ReplicationLogsCustomizer
extends ComponentSupport
implements SupportBundleCustomizer {
    private static final String RAW_FOLDER = "raw";
    private static final String REPLICATION_LOGS_PATH = "log/replication-logs/";
    private final ReplicationConnectionManager replicationConnectionManager;
    private final BlobStoreManager blobStoreManager;
    private final RepositoryManager repositoryManager;
    private static final Path REPLICATION_LOG_PATH = Paths.get("replication", "sync_logs");

    @Inject
    public ReplicationLogsCustomizer(ReplicationConnectionManager replicationConnectionManager, BlobStoreManager blobStoreManager, RepositoryManager repositoryManager) {
        this.replicationConnectionManager = (ReplicationConnectionManager)Preconditions.checkNotNull((Object)replicationConnectionManager);
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    public void customize(SupportBundle supportBundle) {
        this.extractReplicationLogs(supportBundle);
    }

    private void extractReplicationLogs(SupportBundle supportBundle) {
        for (ReplicationConnection replicationConnection : this.replicationConnectionManager.list()) {
            String repositoryName = replicationConnection.getSourceRepositoryName();
            Repository repository = this.repositoryManager.get(repositoryName);
            NestedAttributesMap storage = repository.getConfiguration().attributes("storage");
            String blobStoreName = (String)storage.get("blobStoreName", String.class);
            BlobStore blobStore = this.blobStoreManager.get(blobStoreName);
            RawObjectAccess raw = blobStore.getRawObjectAccess();
            Path rawLogDirPath = Paths.get(repositoryName, RAW_FOLDER);
            raw.listRawObjects(REPLICATION_LOG_PATH.resolve(rawLogDirPath)).map(fileName -> REPLICATION_LOG_PATH.resolve(rawLogDirPath).resolve((String)fileName)).forEach(path2 -> supportBundle.add((SupportBundle.ContentSource)new ReplicationLogsGenerator(SupportBundle.ContentSource.Type.REPLICATIONLOG, this.normalizePath(REPLICATION_LOGS_PATH + rawLogDirPath.resolve(path2.getFileName())), SupportBundle.ContentSource.Priority.LOW, raw, (Path)path2)));
        }
    }

    private String normalizePath(String path) {
        return path.replace("\\", "/");
    }
}

