/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal.analytics;

import com.codahale.metrics.annotation.CachedGauge;
import com.codahale.metrics.annotation.Gauge;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.analytics.AnalyticsMarker;
import com.sonatype.nexus.replication.ReplicationConnectionManager;
import com.sonatype.nexus.replication.db.model.ReplicationConnection;
import com.sonatype.nexus.replication.events.ReplicationQueueBlobReplicatedEvent;
import com.sonatype.nexus.replication.events.ReplicationQueueSizeChangeEvent;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.collections.CollectionUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.io.Hex;
import org.sonatype.nexus.crypto.CryptoHelper;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@Named
@Singleton
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class ReplicationAnalytics
extends ComponentSupport
implements AnalyticsMarker,
EventAware {
    @VisibleForTesting
    final Function<String, String> anonymizeFunction;
    private final ReplicationConnectionManager replicationConnectionManager;
    private final RepositoryManager repositoryManager;
    private final AtomicLong replicatedBlobCount = new AtomicLong();
    private final AtomicLong maxInboundQueueSize = new AtomicLong();
    private final AtomicLong maxOutboundQueueSize = new AtomicLong();

    @Inject
    public ReplicationAnalytics(ReplicationConnectionManager replicationConnectionManager, RepositoryManager repositoryManager, CryptoHelper cryptoHelper) {
        this.replicationConnectionManager = Objects.requireNonNull(replicationConnectionManager);
        this.repositoryManager = Objects.requireNonNull(repositoryManager);
        MessageDigest messageDigest = this.findMessageDigest(cryptoHelper);
        this.anonymizeFunction = messageDigest != null ? input -> Hex.encode((byte[])messageDigest.digest(input.getBytes(StandardCharsets.UTF_8))).substring(0, 20) : input -> String.format("%x", input.hashCode());
    }

    private MessageDigest findMessageDigest(CryptoHelper cryptoHelper) {
        String fallbackDigest = null;
        try {
            MessageDigest messageDigest = cryptoHelper.createDigest("Blake2b");
            return messageDigest;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            fallbackDigest = "SHA3";
            try {
                MessageDigest messageDigest = cryptoHelper.createDigest("SHA3");
                return messageDigest;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                fallbackDigest = "SHA256";
                try {
                    MessageDigest messageDigest = cryptoHelper.createDigest("SHA256");
                    return messageDigest;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException3) {
                    fallbackDigest = "hashcode()";
                    return null;
                }
            }
        }
        finally {
            if (fallbackDigest != null) {
                this.log.debug("Unable to find a suitable digest algorithm for analytics anonymization - falling back to {}.", (Object)fallbackDigest);
            }
        }
    }

    @CachedGauge(name="nexus.analytics.replication_connection_count", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public Integer replicationConnectionCount() {
        return this.replicationConnectionManager.list().size();
    }

    @CachedGauge(name="nexus.analytics.replication_connection_targets", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public List<Map<String, Long>> replicationConnectionTargets() {
        Collection<ReplicationConnection> replicationConnections = this.replicationConnectionManager.list();
        HashMap anonymizeCache = new HashMap();
        return replicationConnections.stream().map(c -> anonymizeCache.computeIfAbsent(c.getSourceRepositoryName(), this.anonymizeFunction)).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().map(e -> Collections.singletonMap((String)e.getKey(), (Long)e.getValue())).collect(Collectors.toList());
    }

    public void reset() {
        this.replicatedBlobCount.set(0L);
        this.maxOutboundQueueSize.set(0L);
        this.maxInboundQueueSize.set(0L);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(ReplicationQueueBlobReplicatedEvent event) {
        this.replicatedBlobCount.addAndGet(event.getBlobCount());
    }

    @Gauge(name="nexus.analytics.replication_replicated_blob_count", absolute=true)
    public Long replicationBlobCount() {
        return this.replicatedBlobCount.get();
    }

    @CachedGauge(name="nexus.analytics.replication_formats", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public Set<String> replicationFormats() {
        return this.replicationConnectionManager.list().stream().map(ReplicationConnection::getSourceRepositoryName).map(arg_0 -> ((RepositoryManager)this.repositoryManager).get(arg_0)).filter(Objects::nonNull).map(r -> r.getFormat().getValue()).collect(Collectors.toSet());
    }

    @CachedGauge(name="nexus.analytics.replication_connection_trusted_count", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public Long replicationTrustedConnectionCount() {
        return this.replicationConnectionManager.list().stream().filter(ReplicationConnection::isUseTrustStore).count();
    }

    @CachedGauge(name="nexus.analytics.replication_connection_filtered_count", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public Long replicationFilteredConnectionTargetCount() {
        return this.replicationConnectionManager.list().stream().filter(c -> CollectionUtils.isNotEmpty(c.getContentRegexes())).count();
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(ReplicationQueueSizeChangeEvent event) {
        if (event.isOutbound()) {
            this.maxOutboundQueueSize.updateAndGet(l -> Math.max(l, event.getQueueSize()));
        } else {
            this.maxInboundQueueSize.updateAndGet(l -> Math.max(l, event.getQueueSize()));
        }
    }

    @Gauge(name="nexus.analytics.replication_outbound_queue_size_max", absolute=true)
    public Long replicationOutboundQueueSizeMax() {
        return this.maxOutboundQueueSize.get();
    }

    @Gauge(name="nexus.analytics.replication_inbound_queue_size_max", absolute=true)
    public Long replicationInboundQueueSizeMax() {
        return this.maxInboundQueueSize.get();
    }
}

