/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.replication.TargetInstanceConnector;
import com.sonatype.nexus.replication.db.model.ReplicationConnection;
import com.sonatype.nexus.replication.internal.ReplicationConnectionException;
import com.sonatype.nexus.replication.internal.ReplicationUtil;
import com.sonatype.nexus.replication.rest.model.ReplicationEnableXO;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.httpclient.HttpClientManager;
import org.sonatype.nexus.httpclient.HttpClientPlan;
import org.sonatype.nexus.httpclient.PreemptiveAuthHttpRequestInterceptor;
import org.sonatype.nexus.httpclient.config.AuthenticationConfiguration;
import org.sonatype.nexus.httpclient.config.ConfigurationCustomizer;
import org.sonatype.nexus.httpclient.config.ConnectionConfiguration;
import org.sonatype.nexus.httpclient.config.HttpClientConfiguration;
import org.sonatype.nexus.httpclient.config.UsernameAuthenticationConfiguration;

@Named
@Singleton
public class TargetInstanceConnectorImpl
extends ComponentSupport
implements TargetInstanceConnector {
    private static final String ENABLE_PATH = "service/rest/beta/replicationtarget/repository/enable";
    private static final String DISABLE_PATH = "service/rest/beta/replicationtarget/repository/%s/enable";
    private static final String ENABLE_ACTION = "enable";
    private static final String DISABLE_ACTION = "disable";
    private final ReplicationUtil replicationUtil;
    private final HttpClientManager httpClientManager;
    private final int httpTimeout;
    private final ObjectMapper objectMapper;

    @Inject
    public TargetInstanceConnectorImpl(ReplicationUtil replicationUtil, HttpClientManager httpClientManager, @Named(value="${nexus.replication.target.http.timeout:-10}") int httpTimeout, ObjectMapper objectMapper) {
        this.replicationUtil = (ReplicationUtil)Preconditions.checkNotNull((Object)replicationUtil);
        this.httpClientManager = (HttpClientManager)Preconditions.checkNotNull((Object)httpClientManager);
        this.httpTimeout = httpTimeout;
        this.objectMapper = (ObjectMapper)Preconditions.checkNotNull((Object)objectMapper);
    }

    @Override
    public void enableReplication(ReplicationConnection replicationConnection) {
        HttpPut enableCall = new HttpPut(this.buildUri(replicationConnection, ENABLE_PATH));
        try {
            String json = this.objectMapper.writeValueAsString((Object)new ReplicationEnableXO(replicationConnection.getDestinationRepositoryName(), replicationConnection.getName(), replicationConnection.getSourceRepositoryName()));
            this.log.debug("Uploading analytics json {}", (Object)json);
            enableCall.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
            this.doRequest(replicationConnection, (HttpUriRequest)enableCall, ENABLE_ACTION);
        }
        catch (JsonProcessingException e) {
            this.log.error("Error creating json for enable call", (Throwable)e);
            throw new ReplicationConnectionException(400, this.buildErrorMessage(replicationConnection, Integer.toString(400), ENABLE_ACTION));
        }
    }

    @Override
    public void disableReplication(ReplicationConnection replicationConnection) {
        this.doRequest(replicationConnection, (HttpUriRequest)new HttpDelete(this.buildUri(replicationConnection, String.format(DISABLE_PATH, replicationConnection.getDestinationRepositoryName()))), DISABLE_ACTION);
    }

    private URI buildUri(ReplicationConnection replicationConnection, String path) {
        return UriBuilder.fromUri((String)replicationConnection.getDestinationInstanceUrl()).path(path).build(new Object[0]);
    }

    private void doRequest(ReplicationConnection replicationConnection, HttpUriRequest httpUriRequest, String action) {
        if (!this.replicationUtil.isReplicationEnabled()) {
            this.log.debug("Replication is not enabled, not sending request to target instance.");
            return;
        }
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (CloseableHttpClient httpClient = this.createHttpClient(replicationConnection);){
                this.log.debug("Sending {} replication request to {}", (Object)action, (Object)httpUriRequest.getURI());
                Throwable throwable2 = null;
                Object var8_13 = null;
                try (CloseableHttpResponse response = httpClient.execute(httpUriRequest);){
                    int status = response.getStatusLine().getStatusCode();
                    this.log.debug("Replication {} request returned with status {}", (Object)action, (Object)status);
                    if (status != 204) {
                        String errorMessage = this.getErrorMessage(response);
                        errorMessage = StringUtils.isEmpty((String)errorMessage) ? "Server responded with status code " + status : errorMessage;
                        throw new ReplicationConnectionException(status, this.buildErrorMessage(replicationConnection, String.valueOf(Integer.toString(status)) + " - " + errorMessage, action));
                    }
                    this.log.debug("Replication {} completed successfully on {}", (Object)action, (Object)httpUriRequest.getURI());
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (HttpHostConnectException e) {
            this.log.warn("Replication {} request to {} failed to connect", new Object[]{action, replicationConnection.getDestinationInstanceUrl(), e});
            throw new ReplicationConnectionException(502, this.buildErrorMessage(replicationConnection, Integer.toString(502), action));
        }
        catch (IOException e) {
            this.log.warn("Replication {} request to {} failed with {}", new Object[]{action, replicationConnection.getDestinationInstanceUrl(), e.getMessage(), e});
            throw new ReplicationConnectionException(500, this.buildErrorMessage(replicationConnection, Integer.toString(500), action));
        }
    }

    private String buildErrorMessage(ReplicationConnection replicationConnection, String msg, String action) {
        return String.format("Failed to %s replication on target instance %s with user %s - %s.  The configuration will have to be manually applied to the target instance (see replication documentation).", action, replicationConnection.getDestinationInstanceUrl(), replicationConnection.getDestinationInstanceUsername(), msg);
    }

    private CloseableHttpClient createHttpClient(ReplicationConnection replicationConnection) {
        return this.createHttpClient(replicationConnection.getDestinationInstanceUsername(), replicationConnection.getDestinationInstancePassword(), replicationConnection.isUseTrustStore());
    }

    @Override
    public CloseableHttpClient createHttpClient(@Nullable String username, @Nullable String password, boolean useTrustStore) {
        HttpClientConfiguration configuration = this.httpClientManager.newConfiguration();
        if (username != null) {
            UsernameAuthenticationConfiguration authentication = new UsernameAuthenticationConfiguration();
            authentication.setUsername(username);
            authentication.setPassword(password);
            configuration.setAuthentication((AuthenticationConfiguration)authentication);
        }
        ConnectionConfiguration connection = new ConnectionConfiguration();
        connection.setTimeout(Time.seconds((long)this.httpTimeout));
        connection.setUseTrustStore(Boolean.valueOf(useTrustStore));
        configuration.setConnection(connection);
        return this.httpClientManager.create((HttpClientPlan.Customizer)new ConfigurationCustomizer(configuration){

            public void customize(HttpClientPlan plan) {
                super.customize(plan);
                plan.getClient().useSystemProperties();
                plan.getClient().addInterceptorFirst((HttpRequestInterceptor)new PreemptiveAuthHttpRequestInterceptor());
            }
        });
    }

    private String getErrorMessage(CloseableHttpResponse response) throws IOException {
        String content = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        try {
            List body = (List)this.objectMapper.readValue(content, (TypeReference)new TypeReference<List<Map<String, String>>>(){});
            return (String)((Map)body.get(0)).get("message");
        }
        catch (Exception e) {
            this.log.error("Error extracting error message from response", (Throwable)e);
            return content;
        }
    }
}

