/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal;

import com.sonatype.nexus.replication.QueueManager;
import com.sonatype.nexus.replication.ReplicationTargetService;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.api.RawObjectAccess;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.replication.BlobEvent;
import org.sonatype.nexus.repository.replication.BlobEventType;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.TaskSupport;

@Named
public class ReplicationSyncLogTask
extends TaskSupport
implements Cancelable {
    private final BlobStoreManager blobStoreManager;
    private final QueueManager replicationIngestQueueManager;
    private final ReplicationTargetService replicationTargetService;
    private static final Path SYNC_LOG_PATH = Paths.get("replication", "sync_logs");
    private static final String ERROR_LINES_SUFFIX = ".error-lines";
    private static final String FILE_ERROR_SUFFIX = ".error";
    private static final String LAST_COMPLETED_FILE = "last_completed";
    private static final String NL = System.lineSeparator();
    private static final Pattern SYNC_LOG_REGEX = Pattern.compile("^\\d{4}-\\d{2}-\\d{2}T\\d{2}-\\d{2}-\\d{2}\\.\\d{3}\\.log$");

    @Inject
    public ReplicationSyncLogTask(BlobStoreManager blobStoreManager, ReplicationTargetService replicationTargetService, @Named(value="ingest") QueueManager replicationIngestQueueManager) {
        super(false);
        this.blobStoreManager = Objects.requireNonNull(blobStoreManager);
        this.replicationIngestQueueManager = Objects.requireNonNull(replicationIngestQueueManager);
        this.replicationTargetService = Objects.requireNonNull(replicationTargetService);
    }

    protected Void execute() throws Exception {
        for (Repository repository : this.replicationTargetService.getEnabledTargetRepositories()) {
            if (this.isCanceled()) continue;
            try {
                this.handleRepository(repository);
            }
            catch (Exception e) {
                this.log.error("An error occurred replicating {}", (Object)repository.getName(), (Object)e);
            }
        }
        return null;
    }

    private void handleRepository(Repository repo) throws IOException {
        NestedAttributesMap storage = repo.getConfiguration().attributes("storage");
        String blobStoreName = (String)storage.get("blobStoreName", String.class);
        BlobStore blobStore = this.blobStoreManager.get(blobStoreName);
        String lastCompleted = this.getLastCompletedTimestamp(repo, blobStore);
        RawObjectAccess raw = blobStore.getRawObjectAccess();
        List syncLogs = raw.listRawObjects(SYNC_LOG_PATH.resolve(repo.getName())).filter(this::isSyncLog).filter(n -> this.notCompleted((String)n, lastCompleted)).collect(Collectors.toList());
        for (String filename : syncLogs) {
            if (this.isCanceled()) continue;
            Path filePath = this.getSyncLogFilePath(repo, filename);
            try {
                InputStream in = raw.getRawObject(filePath);
                if (in != null) {
                    List<String> errorLines = this.handleSyncLog(in, blobStore, repo.getName(), filename);
                    if (!errorLines.isEmpty()) {
                        this.writeErrorLines(blobStore, repo.getName(), filename, errorLines);
                    }
                } else {
                    this.log.warn("Could not find sync log {}", (Object)filename);
                }
            }
            catch (Exception e) {
                this.log.error("Error handling sync log file {} Creating {}", new Object[]{filePath, this.getFileErrorPath(repo.getName(), filename), e});
                raw.putRawObject(this.getFileErrorPath(repo.getName(), filename), (InputStream)new ByteArrayInputStream(new byte[0]));
            }
            raw.putRawObject(this.getSyncLogFilePath(repo, LAST_COMPLETED_FILE), (InputStream)new ByteArrayInputStream(filename.getBytes()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> handleSyncLog(InputStream in, BlobStore blobStore, String repositoryName, String filename) throws IOException {
        if (this.log.isDebugEnabled()) {
            String blobStoreName = blobStore.getBlobStoreConfiguration().getName();
            this.log.debug("blobstore {} queue size: {}", (Object)blobStoreName, (Object)this.replicationIngestQueueManager.size(blobStoreName));
        }
        ArrayList<String> errorLines = new ArrayList<String>();
        Throwable throwable = null;
        Object var7_8 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    return errorLines;
                }
                if (this.isCanceled()) continue;
                try {
                    this.handleRecord(line, blobStore, repositoryName);
                }
                catch (Exception e) {
                    this.log.error("Error handling sync record {} copying record to {}", new Object[]{line, this.getLineErrorPath(repositoryName, filename), e});
                    errorLines.add(line);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private void handleRecord(String line, BlobStore blobStore, String repositoryName) {
        if (!line.isEmpty()) {
            String[] columns = line.split(" ");
            String code = columns[0];
            String blobId = columns[1];
            BlobEventType eventType = BlobEventType.fromCode((String)code);
            if (eventType == null) {
                throw new RuntimeException("Unknown action " + code);
            }
            this.replicationIngestQueueManager.addToQueue(blobStore.getBlobStoreConfiguration().getName(), new BlobEvent().withBlobId(blobId).withRepositoryName(repositoryName).withBlobEventType(eventType));
        }
    }

    private void writeErrorLines(BlobStore blobStore, String repositoryName, String filename, List<String> errorLines) {
        StringBuilder errorLog = new StringBuilder();
        errorLines.forEach(l -> {
            StringBuilder stringBuilder2 = errorLog.append((String)l).append(NL);
        });
        blobStore.getRawObjectAccess().putRawObject(this.getLineErrorPath(repositoryName, filename), (InputStream)new ByteArrayInputStream(errorLog.toString().getBytes(StandardCharsets.UTF_8)));
    }

    private Path getLineErrorPath(String repositoryName, String filename) {
        return SYNC_LOG_PATH.resolve(Paths.get(repositoryName, String.valueOf(filename) + ERROR_LINES_SUFFIX));
    }

    private Path getFileErrorPath(String repositoryName, String filename) {
        return SYNC_LOG_PATH.resolve(Paths.get(repositoryName, String.valueOf(filename) + FILE_ERROR_SUFFIX));
    }

    private boolean isSyncLog(String filename) {
        return SYNC_LOG_REGEX.matcher(filename).find();
    }

    private boolean notCompleted(String filename, String lastIngestedTimestamp) {
        return lastIngestedTimestamp == null || filename.compareTo(lastIngestedTimestamp) > 0;
    }

    private String getLastCompletedTimestamp(Repository repo, BlobStore blobStore) throws IOException {
        InputStream in = blobStore.getRawObjectAccess().getRawObject(this.getSyncLogFilePath(repo, LAST_COMPLETED_FILE));
        if (in == null) {
            return null;
        }
        return IOUtils.toString((InputStream)in, (String)StandardCharsets.UTF_8.name()).trim();
    }

    private Path getSyncLogFilePath(Repository repo, String filename) {
        return SYNC_LOG_PATH.resolve(Paths.get(repo.getName(), filename));
    }

    public String getMessage() {
        return "Ingest replication logs and add records to the ingest queue";
    }
}

