/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.sonatype.nexus.replication.internal.ReplicationUtil;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.rapture.CapabilityEnabledXO;
import org.sonatype.nexus.rapture.StateContributor;

@Named
@Singleton
public class ReplicationStateContributor
implements StateContributor {
    private final ReplicationUtil replicationUtil;
    @Inject
    @Named(value="${nexus.replication.http.enabled:-false}")
    private boolean httpReplicationEnabled;

    @Inject
    public ReplicationStateContributor(ReplicationUtil replicationUtil) {
        this.replicationUtil = (ReplicationUtil)Preconditions.checkNotNull((Object)replicationUtil);
    }

    @Nullable
    public Map<String, Object> getState() {
        return ImmutableMap.of((Object)"replicationCapabilityState", (Object)new CapabilityEnabledXO(Boolean.valueOf(this.replicationUtil.isReplicationEnabled())), (Object)"replicationFeatureEnabled", (Object)(this.httpReplicationEnabled && this.isReplicationLicensed() ? 1 : 0));
    }

    private boolean isReplicationLicensed() {
        return true;
    }
}

