/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal;

import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.security.config.CRole;
import org.sonatype.nexus.security.config.MemorySecurityConfiguration;
import org.sonatype.nexus.security.config.SecurityContributor;
import org.sonatype.nexus.security.config.SecurityContributorSupport;
import org.sonatype.nexus.security.config.memory.MemoryCPrivilege;

@Named
@Singleton
public class ReplicationSecurityContributor
extends SecurityContributorSupport
implements SecurityContributor {
    public static final String REPLICATION_DOMAIN = "replication";
    public static final String REPLICATION_ROLE_ID = "replication-role";
    public static final String REPLICATION_ROLE_NAME = "Replication role";
    public static final String REPLICATION_ROLE_DESCRIPTION = "Provides privileges required to administer replication connections";
    public static final String REPLICATION_PRIV_ID_PREFIX = "nx-replication";
    public static final String REPOSITORY_VIEW_ALL_PRIV_ID = "nx-repository-view-*-*-*";
    public static final String REPOSITORY_ADMIN_ALL_EDIT_PRIV_ID = "nx-repository-admin-*-*-edit";

    public MemorySecurityConfiguration getContribution() {
        MemorySecurityConfiguration config = new MemorySecurityConfiguration();
        List privileges = this.createCrudApplicationPrivileges(REPLICATION_PRIV_ID_PREFIX, REPLICATION_DOMAIN);
        privileges.forEach(arg_0 -> ((MemorySecurityConfiguration)config).addPrivilege(arg_0));
        List<String> privilegeIds = privileges.stream().map(MemoryCPrivilege::getId).collect(Collectors.toList());
        privilegeIds.add(REPOSITORY_VIEW_ALL_PRIV_ID);
        privilegeIds.add(REPOSITORY_ADMIN_ALL_EDIT_PRIV_ID);
        config.addRole((CRole)this.createRole(REPLICATION_ROLE_ID, REPLICATION_ROLE_NAME, REPLICATION_ROLE_DESCRIPTION, privilegeIds.toArray(new String[0])));
        return config;
    }
}

