/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal;

import com.sonatype.nexus.replication.QueueManager;
import com.sonatype.nexus.replication.events.ReplicationIngestQueueItemAddedEvent;
import com.sonatype.nexus.replication.internal.QueueManagerSupport;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.jmx.reflect.ManagedAttribute;
import org.sonatype.nexus.jmx.reflect.ManagedObject;

@Named(value="ingest")
@ManagedObject
@Singleton
public class ReplicationIngestQueueManagerImpl
extends QueueManagerSupport
implements QueueManager {
    public static final String QUEUE_TYPE = "ingest";
    public static final String REPLICATION_QUEUE_DIR = "blobs/_replicationingest";
    private int maxBatchSize = 100;

    @Inject
    public ReplicationIngestQueueManagerImpl(ApplicationDirectories applicationDirectories, EventManager eventManager) {
        super(applicationDirectories, eventManager, ReplicationIngestQueueItemAddedEvent::new, false);
    }

    @Override
    protected String getQueuePath() {
        return REPLICATION_QUEUE_DIR;
    }

    @Override
    protected int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    protected void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    @Override
    @ManagedAttribute
    public Map<String, Integer> getQueueSizes() {
        return super.getQueueSizes();
    }
}

