/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.replication.FileListingWatcher;
import com.sonatype.nexus.replication.internal.ReplicationBlobMetadataStorageImpl;
import com.sonatype.nexus.replication.internal.ReplicationBlobStoreStatusManagerImpl;
import com.sonatype.nexus.replication.internal.ReplicationCleanup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.capability.CapabilityConfigurationSupport;
import org.sonatype.nexus.capability.CapabilityDescriptorSupport;
import org.sonatype.nexus.capability.CapabilitySupport;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.capability.Condition;
import org.sonatype.nexus.capability.Tag;
import org.sonatype.nexus.capability.Taggable;
import org.sonatype.nexus.capability.condition.NexusConditions;
import org.sonatype.nexus.formfields.FormField;

@Named(value="replication")
public class ReplicationCapability
extends CapabilitySupport<Configuration> {
    public static final String TYPE_ID = "replication";
    public static final CapabilityType TYPE = CapabilityType.capabilityType((String)"replication");
    private final ReplicationBlobMetadataStorageImpl replicationBlobMetadataStorageImpl;
    private final ReplicationBlobStoreStatusManagerImpl replicationBlobStoreStatusManagerImpl;
    private final FileListingWatcher fileListingWatcher;
    private final ReplicationCleanup replicationCleanup;
    private final Condition nexusActiveCondition;
    static final Messages messages = (Messages)I18N.create(Messages.class);
    private boolean enabled = false;

    @Inject
    public ReplicationCapability(ReplicationBlobMetadataStorageImpl replicationBlobMetadataStorageImpl, ReplicationBlobStoreStatusManagerImpl replicationBlobStoreStatusManagerImpl, FileListingWatcher fileListingWatcher, ReplicationCleanup replicationCleanup, NexusConditions nexusConditions) {
        this.replicationBlobMetadataStorageImpl = (ReplicationBlobMetadataStorageImpl)((Object)Preconditions.checkNotNull((Object)((Object)replicationBlobMetadataStorageImpl)));
        this.replicationBlobStoreStatusManagerImpl = (ReplicationBlobStoreStatusManagerImpl)Preconditions.checkNotNull((Object)replicationBlobStoreStatusManagerImpl);
        this.fileListingWatcher = (FileListingWatcher)Preconditions.checkNotNull((Object)fileListingWatcher);
        this.replicationCleanup = (ReplicationCleanup)((Object)Preconditions.checkNotNull((Object)((Object)replicationCleanup)));
        this.nexusActiveCondition = ((NexusConditions)Preconditions.checkNotNull((Object)nexusConditions)).active();
    }

    protected Configuration createConfig(Map<String, String> properties) {
        return new Configuration(properties);
    }

    @Nullable
    protected String renderDescription() {
        if (this.context().isActive()) {
            return messages.enabled();
        }
        return messages.disabled();
    }

    public Condition activationCondition() {
        return this.conditions().capabilities().passivateCapabilityDuringUpdate();
    }

    protected void onActivate(Configuration config) {
        this.replicationBlobMetadataStorageImpl.setEnabled(true);
        this.replicationBlobStoreStatusManagerImpl.setEnabled(true);
        if (!this.fileListingWatcher.isStarted()) {
            try {
                this.fileListingWatcher.start();
            }
            catch (Exception e) {
                this.log.error("Failed to start the FileListingWatcher", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        this.enabled = true;
    }

    protected void onPassivate(Configuration config) {
        this.enabled = false;
        this.replicationBlobMetadataStorageImpl.setEnabled(false);
        this.replicationBlobStoreStatusManagerImpl.setEnabled(false);
        if (this.fileListingWatcher.isStarted()) {
            try {
                this.fileListingWatcher.stop();
            }
            catch (Exception e) {
                this.log.error("Failed to stop the FileListingWatcher", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        if (this.nexusActiveCondition.isSatisfied()) {
            this.replicationCleanup.run();
        }
    }

    public static Messages getMessages() {
        return messages;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static class Configuration
    extends CapabilityConfigurationSupport {
        public Configuration(Map<String, String> properties) {
        }
    }

    @Named(value="replication")
    @Singleton
    public static class Descriptor
    extends CapabilityDescriptorSupport<Configuration>
    implements Taggable {
        public Descriptor() {
            this.setExposed(true);
            this.setHidden(false);
        }

        public CapabilityType type() {
            return TYPE;
        }

        public String name() {
            return ReplicationCapability.getMessages().name();
        }

        public List<FormField> formFields() {
            return new ArrayList<FormField>();
        }

        protected String renderAbout() {
            return this.render("replication-about.vm");
        }

        public Set<Tag> getTags() {
            return new HashSet<Tag>(Collections.singletonList(Tag.categoryTag((String)ReplicationCapability.getMessages().category())));
        }

        @Nullable
        public String getDisableWarningMessage() {
            return messages.disableWarningMessage();
        }

        @Nullable
        public String getDeleteWarningMessage() {
            return messages.disableWarningMessage();
        }
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Replication")
        public String name();

        @MessageBundle.DefaultMessage(value="Replication")
        public String category();

        @MessageBundle.DefaultMessage(value="Disabled")
        public String disabled();

        @MessageBundle.DefaultMessage(value="Enabled")
        public String enabled();

        @MessageBundle.DefaultMessage(value="You are about to disable replication. This will permanently remove all replication configurations. This action cannot be undone. Do you want to proceed?")
        public String disableWarningMessage();
    }
}

