/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.OffsetDateTime;
import java.util.AbstractMap;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobAttributes;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.common.app.ApplicationVersion;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.storage.BlobMetadataStorage;

@Named
@Priority(value=0x7FFFFFFF)
@Singleton
public class ReplicationBlobMetadataStorageImpl
extends ComponentSupport
implements BlobMetadataStorage {
    private static final String NESTED_ATTRIBUTE_KEY_SEPARATOR = ".";
    private static final String NEXUS_VERSION = "nexus.version";
    private static final String CHECKSUM = "checksum.";
    private boolean enabled = false;
    private final ApplicationVersion applicationVersion;

    @Inject
    public ReplicationBlobMetadataStorageImpl(ApplicationVersion applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void attach(BlobStore blobStore, BlobId blobId, NestedAttributesMap componentAttributes, NestedAttributesMap assetAttributes, Map<String, String> checksums) {
        try {
            if (this.enabled) {
                this.log.debug("Attaching attributes to blob {} {} {}", new Object[]{blobId, componentAttributes, assetAttributes});
                BlobAttributes blobAttributes = blobStore.getBlobAttributes(blobId);
                Map blobHeaders = blobAttributes.getHeaders();
                if (componentAttributes != null) {
                    this.forEachNestedAttribute("", componentAttributes, entry -> {
                        String string = blobHeaders.put("attributes.component." + (String)entry.getKey(), Objects.toString(entry.getValue(), ""));
                    });
                }
                this.forEachNestedAttribute("", assetAttributes, entry -> {
                    String string = blobHeaders.put("attributes.asset." + (String)entry.getKey(), Objects.toString(entry.getValue(), ""));
                });
                if (checksums != null) {
                    for (Map.Entry<String, String> checksum : checksums.entrySet()) {
                        blobHeaders.put("attributes.asset.checksum." + checksum.getKey(), checksum.getValue());
                    }
                }
                blobHeaders.put(NEXUS_VERSION, this.applicationVersion.getVersion());
                blobAttributes.store();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void forEachNestedAttribute(String keyPrefix, NestedAttributesMap attributes, Consumer<Map.Entry<String, Object>> consumer) {
        if (attributes != null) {
            for (Map.Entry entry : attributes) {
                if (entry.getValue() instanceof Map) {
                    this.forEachNestedAttribute(String.valueOf(keyPrefix) + (String)entry.getKey() + NESTED_ATTRIBUTE_KEY_SEPARATOR, attributes.child((String)entry.getKey()), consumer);
                    continue;
                }
                Object value = entry.getValue();
                if (value instanceof Date) {
                    value = "{dateepochmillis}" + ((Date)value).getTime();
                } else if (value instanceof DateTime) {
                    value = "{jodadatetimeepochmillis}" + ((DateTime)value).toDate().getTime();
                } else if (value instanceof OffsetDateTime) {
                    value = "{datetimeepochmillis}" + ((OffsetDateTime)value).toEpochSecond() * 1000L;
                }
                consumer.accept(new AbstractMap.SimpleImmutableEntry(String.valueOf(keyPrefix) + (String)entry.getKey(), value));
            }
        }
    }
}

