/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.replication.FileListingWatcher;
import com.sonatype.nexus.replication.ReplicationConnectionManager;
import com.sonatype.nexus.replication.db.model.ReplicationConnection;
import com.sonatype.nexus.replication.internal.ExecutorServiceUtil;
import com.sonatype.nexus.replication.internal.ReplicationUtil;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@Named
@Singleton
public class FileListingWatcherImpl
extends StateGuardLifecycleSupport
implements FileListingWatcher {
    private ScheduledExecutorService scheduledExecutorService;
    private ExecutorService consumerExecutorService;
    private final ConcurrentMap<String, Consumer<Path>> consumerMap = new ConcurrentHashMap<String, Consumer<Path>>();
    private final AtomicBoolean continueWatching = new AtomicBoolean(true);
    private final BlobStoreManager blobStoreManager;
    private final ReplicationUtil replicationUtil;
    private final ReplicationConnectionManager replicationConnectionManager;
    private final RepositoryManager repositoryManager;
    private final ExecutorServiceUtil executorServiceUtil;

    @Inject
    public FileListingWatcherImpl(BlobStoreManager blobStoreManager, ReplicationUtil replicationUtil, ReplicationConnectionManager replicationConnectionManager, RepositoryManager repositoryManager, ExecutorServiceUtil executorServiceUtil) {
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.replicationUtil = (ReplicationUtil)Preconditions.checkNotNull((Object)replicationUtil);
        this.replicationConnectionManager = (ReplicationConnectionManager)Preconditions.checkNotNull((Object)replicationConnectionManager);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.executorServiceUtil = (ExecutorServiceUtil)Preconditions.checkNotNull((Object)executorServiceUtil);
    }

    protected void doStart() {
        this.continueWatching.set(true);
        if (!this.replicationUtil.isReplicationEnabled()) {
            return;
        }
        this.consumerExecutorService = this.executorServiceUtil.newConsumerExecutorService();
        this.scheduledExecutorService = this.executorServiceUtil.newFileWatcherScheduledExecutorService();
        this.executorServiceUtil.scheduleFileWatcher(this.scheduledExecutorService, this::watchFileListings);
    }

    protected void doStop() {
        this.continueWatching.set(false);
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
            this.scheduledExecutorService = null;
        }
        if (this.consumerExecutorService != null) {
            this.consumerExecutorService.shutdownNow();
            this.consumerExecutorService = null;
        }
    }

    @Override
    public void addReplicationConnection(String replicationConnectionId, Consumer<Path> consumer) {
        this.consumerMap.putIfAbsent(replicationConnectionId, consumer);
    }

    @Override
    public void removeReplicationConnection(String replicationConnectionId) {
        this.consumerMap.remove(replicationConnectionId);
    }

    private void watchFileListings() {
        Iterator it = this.consumerMap.entrySet().iterator();
        while (it.hasNext() && this.continueWatching.get()) {
            Map.Entry entry = it.next();
            try {
                if (!this.watchFileListing((String)entry.getKey(), (Consumer)entry.getValue())) continue;
                this.log.debug("Watch thread removing replicationConnection {} watch", entry.getKey());
                it.remove();
            }
            catch (Exception e) {
                this.log.debug("Watch thread has failed with exception while processing replicationConnection {}", entry.getKey(), (Object)e);
            }
        }
    }

    private boolean watchFileListing(String replicationConnectionId, Consumer<Path> consumer) {
        ReplicationConnection replicationConnection = this.replicationConnectionManager.getById(replicationConnectionId).orElse(null);
        if (replicationConnection == null) {
            this.log.debug("Watch thread found invalid replicationConnectionId {} in watchlist", (Object)replicationConnectionId);
            return true;
        }
        Repository repository = this.repositoryManager.get(replicationConnection.getSourceRepositoryName());
        if (repository == null) {
            this.log.debug("Watch thread found invalid source repository name {} in watchlist", (Object)replicationConnection.getSourceRepositoryName());
            return true;
        }
        String blobStoreName = (String)repository.getConfiguration().attributes("storage").get("blobStoreName");
        BlobStore blobStore = this.blobStoreManager.get(blobStoreName);
        if (blobStore == null) {
            this.log.debug("Watch thread found invalid blobstore name {} in watchlist", (Object)blobStoreName);
            return true;
        }
        Path fileListingPath = FileListingWatcher.getFileListingPath(replicationConnection.getName(), replicationConnection.getDestinationRepositoryName());
        if (!blobStore.getRawObjectAccess().hasRawObject(fileListingPath)) {
            this.log.debug("Watch thread found filelisting {} DOES NOT exist in blobstore {}, calling consumer", (Object)fileListingPath, (Object)blobStoreName);
            this.consumerExecutorService.submit(() -> consumer.accept(fileListingPath));
            return true;
        }
        this.log.trace("Watch thread found file filelisting {} DOES exist in blobstore {}", (Object)fileListingPath, (Object)blobStoreName);
        return false;
    }
}

