/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.subject.Subject;
import org.sonatype.nexus.security.subject.FakeAlmightySubject;
import org.sonatype.nexus.thread.NexusExecutorService;
import org.sonatype.nexus.thread.NexusScheduledExecutorService;
import org.sonatype.nexus.thread.NexusThreadFactory;

@Named
@Singleton
public class ExecutorServiceUtil {
    private static final String FILEWATCH_THREADGROUP_NAME = "replication-flwatcher";
    private static final String CONSUMER_THREADGROUP_NAME = "replication-flconsumer";
    private static final String INGESTER_THREADGROUP_NAME = "replication-ingester";
    private final long filewatchPeriod;
    private final TimeUnit filewatchUnit;
    private final int consumerCorePoolSize;
    private final int consumerMaxPoolSize;
    private final int consumerMaxQueued;
    private final int consumerKeepAliveTime;
    private final int ingesterCorePoolSize;
    private final int ingesterMaxPoolSize;
    private final int ingesterKeepAliveTime;
    private final int ingesterMaxQueued;
    private volatile ExecutorService ingesterExecutorService;

    @Inject
    public ExecutorServiceUtil(@Named(value="${nexus.replication.filewatch.period:-1}") long filewatchPeriod, @Named(value="${nexus.replication.filewatch.unit:-SECONDS}") String fileWatchUnit, @Named(value="${nexus.replication.filewatch.consumer.corePoolSize:-10}") int consumerCorePoolSize, @Named(value="${nexus.replication.filewatch.consumer.maxPoolSize:-10}") int consumerMaxPoolSize, @Named(value="${nexus.replication.filewatch.consumer.maxQueued:-100}") int consumerMaxQueued, @Named(value="${nexus.replication.filewatch.consumer.keepAliveTime:-30}") int consumerKeepAliveTime, @Named(value="${nexus.replication.ingester.corePoolSize:-10}") int ingesterCorePoolSize, @Named(value="${nexus.replication.ingester.maxPoolSize:-10}") int ingesterMaxPoolSize, @Named(value="${nexus.replication.ingester.maxQueued:-1000}") int ingesterMaxQueued, @Named(value="${nexus.replication.ingester.keepAliveTime:-30}") int ingesterKeepAliveTime) {
        this.filewatchPeriod = filewatchPeriod;
        this.filewatchUnit = TimeUnit.valueOf(fileWatchUnit);
        this.consumerCorePoolSize = consumerCorePoolSize;
        this.consumerMaxPoolSize = consumerMaxPoolSize;
        this.consumerMaxQueued = consumerMaxQueued;
        this.consumerKeepAliveTime = consumerKeepAliveTime;
        this.ingesterCorePoolSize = ingesterCorePoolSize;
        this.ingesterMaxPoolSize = ingesterMaxPoolSize;
        this.ingesterMaxQueued = ingesterMaxQueued;
        this.ingesterKeepAliveTime = ingesterKeepAliveTime;
    }

    public ScheduledExecutorService newFileWatcherScheduledExecutorService() {
        return NexusScheduledExecutorService.forFixedSubject((ScheduledExecutorService)new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NexusThreadFactory(FILEWATCH_THREADGROUP_NAME, FILEWATCH_THREADGROUP_NAME)), (Subject)FakeAlmightySubject.TASK_SUBJECT);
    }

    public ExecutorService newConsumerExecutorService() {
        return NexusExecutorService.forFixedSubject((ExecutorService)new ThreadPoolExecutor(this.consumerCorePoolSize, this.consumerMaxPoolSize, (long)this.consumerKeepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.consumerMaxQueued), (ThreadFactory)new NexusThreadFactory(CONSUMER_THREADGROUP_NAME, CONSUMER_THREADGROUP_NAME)), (Subject)FakeAlmightySubject.TASK_SUBJECT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService getIngesterExecutorService() {
        if (this.ingesterExecutorService == null) {
            ExecutorServiceUtil executorServiceUtil = this;
            synchronized (executorServiceUtil) {
                if (this.ingesterExecutorService == null) {
                    this.ingesterExecutorService = NexusExecutorService.forFixedSubject((ExecutorService)new ThreadPoolExecutor(this.ingesterCorePoolSize, this.ingesterMaxPoolSize, (long)this.ingesterKeepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.ingesterMaxQueued), (ThreadFactory)new NexusThreadFactory(INGESTER_THREADGROUP_NAME, INGESTER_THREADGROUP_NAME)), (Subject)FakeAlmightySubject.TASK_SUBJECT);
                }
            }
        }
        return this.ingesterExecutorService;
    }

    public void scheduleFileWatcher(ScheduledExecutorService scheduledExecutorService, Runnable runnable) {
        scheduledExecutorService.scheduleAtFixedRate(runnable, 0L, this.filewatchPeriod, this.filewatchUnit);
    }
}

