/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal;

import com.sonatype.nexus.replication.QueueManager;
import com.sonatype.nexus.replication.internal.ExecutorServiceUtil;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.replication.BlobEvent;
import org.sonatype.nexus.repository.replication.ReplicationIngester;
import org.sonatype.nexus.repository.replication.ReplicationIngesterFactory;

@Named
@Singleton
public class BlobStoreIngester
extends ComponentSupport {
    private final ReplicationIngesterFactory replicationIngesterFactory;
    private final QueueManager replicationIngestQueueManager;
    private final RepositoryManager repositoryManager;
    private final ExecutorServiceUtil executorServiceUtil;
    private final int retryLimit;

    @Inject
    public BlobStoreIngester(ReplicationIngesterFactory replicationIngesterFactory, @Named(value="ingest") QueueManager replicationIngestQueueManager, RepositoryManager repositoryManager, ExecutorServiceUtil executorServiceUtil, @Named(value="${nexus.replication.ingester.retry.limit:-3}") int retryLimit) {
        this.replicationIngesterFactory = replicationIngesterFactory;
        this.replicationIngestQueueManager = Objects.requireNonNull(replicationIngestQueueManager);
        this.repositoryManager = Objects.requireNonNull(repositoryManager);
        this.retryLimit = retryLimit;
        this.executorServiceUtil = executorServiceUtil;
    }

    public void execute(String blobstore, AtomicBoolean status) {
        boolean running = true;
        try {
            try {
                ExecutorService executorService = this.executorServiceUtil.getIngesterExecutorService();
                while (running) {
                    if (!Thread.interrupted()) {
                        List<BlobEvent> blobEvents = this.replicationIngestQueueManager.takeNextBatch(blobstore);
                        if (!blobEvents.isEmpty()) {
                            CountDownLatch latch = new CountDownLatch(blobEvents.size());
                            blobEvents.forEach(e -> {
                                Future<?> future = executorService.submit(() -> this.ingest(blobstore, (BlobEvent)e, latch));
                            });
                            latch.await();
                            this.replicationIngestQueueManager.removeInUse(blobstore);
                            continue;
                        }
                        running = false;
                        continue;
                    }
                    running = false;
                }
            }
            catch (Exception e2) {
                this.log.error("Unexpected ingestion error", (Throwable)e2);
                this.replicationIngestQueueManager.clearInUse(blobstore);
                status.set(false);
                this.replicationIngestQueueManager.maybeNotify(blobstore);
            }
        }
        finally {
            status.set(false);
            this.replicationIngestQueueManager.maybeNotify(blobstore);
        }
    }

    private void ingest(String blobstore, BlobEvent blobEvent, CountDownLatch latch) {
        block8: {
            try {
                try {
                    String repositoryName = blobEvent.getRepositoryName();
                    ReplicationIngester ingester = this.getIngester(repositoryName);
                    if (ingester != null) {
                        ingester.ingestBlob(blobEvent.getBlobId(), blobstore, blobEvent.getRepositoryName(), blobEvent.getBlobEventType());
                        break block8;
                    }
                    this.log.warn("Unable to find ingester for {}", (Object)repositoryName);
                }
                catch (Exception e) {
                    if (blobEvent.getRetryCount() < this.retryLimit) {
                        this.log.debug("Could not ingest blob but will retry (count {})", (Object)blobEvent.getRetryCount(), (Object)e);
                        blobEvent.withInUse(false).retry();
                        this.replicationIngestQueueManager.addToQueue(blobstore, blobEvent);
                    } else {
                        this.log.error("Could not ingest blob (retry count exceeded)", (Throwable)e);
                    }
                    latch.countDown();
                }
            }
            finally {
                latch.countDown();
            }
        }
    }

    @Nullable
    private ReplicationIngester getIngester(String repositoryName) {
        Repository repository = this.repositoryManager.get(repositoryName);
        if (repository != null) {
            return this.replicationIngesterFactory.find(repository.getFormat().getValue());
        }
        return null;
    }
}

