/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.replication.internal.BlobAttributeBackfillService;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.blobstore.api.BlobAttributes;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.repository.replication.ReplicationBlobStoreStatusManager;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.TaskInterruptedException;
import org.sonatype.nexus.scheduling.TaskSupport;
import org.sonatype.nexus.thread.NexusForkJoinPoolFactory;

@Named
public class BlobAttributeBackfillTask
extends TaskSupport
implements Cancelable {
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private static final int MAX_BLOBS_PER_WORKER = 128;
    private final BlobAttributeBackfillService blobAttributeBackfillService;
    private final BlobStoreManager blobStoreManager;
    private final ForkJoinPool forkJoinPool;
    private final ReplicationBlobStoreStatusManager replicationBlobStoreStatusManager;

    @Inject
    public BlobAttributeBackfillTask(BlobAttributeBackfillService blobAttributeBackfillService, BlobStoreManager blobStoreManager, ReplicationBlobStoreStatusManager replicationBlobStoreStatusManager) {
        this.blobAttributeBackfillService = (BlobAttributeBackfillService)Preconditions.checkNotNull((Object)blobAttributeBackfillService);
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.replicationBlobStoreStatusManager = (ReplicationBlobStoreStatusManager)Preconditions.checkNotNull((Object)replicationBlobStoreStatusManager);
        this.forkJoinPool = NexusForkJoinPoolFactory.createForkJoinPool((String)"blob-attribute-backfill-");
    }

    public String getMessage() {
        return messages.message();
    }

    public Object execute() throws Exception {
        String blobStoreName = this.getConfiguration().getString("blobstore");
        BlobStore blobStore = (BlobStore)Preconditions.checkNotNull((Object)this.blobStoreManager.get(blobStoreName));
        this.ensureValidStatus(blobStore);
        this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Backfilling asset attributes to blob store {}", (Object)blobStoreName);
        this.updateStatus(blobStore, ReplicationBlobStoreStatusManager.BlobStoreReplicationStatus.ATTRIBUTES_UPGRADING);
        try {
            try {
                this.processBlobs(blobStore, (blobId, blobAttributes) -> this.blobAttributeBackfillService.backfillBlobAttributes(blobStore, (BlobId)blobId, (BlobAttributes)blobAttributes));
            }
            catch (CancellationException e) {
                this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Tasks execution pool has been cancelled. isCanceled: {}", (Object)this.isCanceled(), (Object)e);
                throw new TaskInterruptedException("Task has been interrupted", this.isCanceled());
            }
            catch (ExecutionException e) {
                this.log.error("Blob attribute backfill task did not complete successfully", (Throwable)e);
                this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "Blob attribute backfill task did not complete successfully", (Throwable)e);
                throw e;
            }
        }
        finally {
            if (!this.forkJoinPool.isShutdown()) {
                this.forkJoinPool.shutdown();
            }
        }
        this.updateStatus(blobStore, ReplicationBlobStoreStatusManager.BlobStoreReplicationStatus.ATTRIBUTES_PRESENT);
        return null;
    }

    private void processBlobs(BlobStore blobStore, BiConsumer<BlobId, BlobAttributes> blobIdConsumer) throws InterruptedException, ExecutionException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Stream stream = blobStore.getBlobIdStream();){
            ((ForkJoinTask)this.forkJoinPool.submit(() -> ((Stream)stream.parallel()).forEach(blobId -> {
                BlobAttributes blobAttributes = this.getBlobAttributes(blobStore, (BlobId)blobId);
                if (this.isNotDirectPathBlob(blobAttributes)) {
                    this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Processing blobId {} for replication preparation", blobId);
                    blobIdConsumer.accept((BlobId)blobId, this.getBlobAttributes(blobStore, (BlobId)blobId));
                } else {
                    this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Skipping processing of blobId {} for replication preparation because it's a directpath blob", blobId);
                }
            }))).get();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void cancel() {
        super.cancel();
        this.forkJoinPool.shutdownNow();
    }

    private boolean isNotDirectPathBlob(BlobAttributes blobAttributes) {
        return !Boolean.parseBoolean(blobAttributes.getHeaders().getOrDefault("BlobStore.direct-path", "false"));
    }

    private BlobAttributes getBlobAttributes(BlobStore blobStore, BlobId blobId) {
        return blobStore.getBlobAttributes(blobId);
    }

    private void ensureValidStatus(BlobStore blobStore) {
        ReplicationBlobStoreStatusManager.BlobStoreReplicationStatus status = this.replicationBlobStoreStatusManager.getReplicationStatus(blobStore.getBlobStoreConfiguration());
        this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Blob store replication attribute status currently {}", (Object)status);
        if (status == ReplicationBlobStoreStatusManager.BlobStoreReplicationStatus.ATTRIBUTES_PRESENT) {
            throw new IllegalStateException("Blob store " + blobStore + " already has attributes present");
        }
    }

    private void updateStatus(BlobStore blobStore, ReplicationBlobStoreStatusManager.BlobStoreReplicationStatus status) throws Exception {
        BlobStoreConfiguration blobStoreConfiguration = blobStore.getBlobStoreConfiguration();
        this.replicationBlobStoreStatusManager.setReplicationStatus(blobStoreConfiguration, status);
        this.blobStoreManager.update(blobStoreConfiguration);
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Run replication blob attribute backfill task")
        public String message();
    }
}

