/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.db.model;

import java.util.Objects;

public class ReplicationEvent {
    private long id;
    private String repositoryName;
    private Type type;
    private String assetPath;
    private Status status = Status.READY;
    private String replicationConnectionId;
    private String node;

    public long getId() {
        return this.id;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public Type getType() {
        return this.type;
    }

    public String getAssetPath() {
        return this.assetPath;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getReplicationConnectionId() {
        return this.replicationConnectionId;
    }

    public String getNode() {
        return this.node;
    }

    public ReplicationEvent withId(long id) {
        this.id = id;
        return this;
    }

    public ReplicationEvent withRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
        return this;
    }

    public ReplicationEvent withType(Type type) {
        this.type = type;
        return this;
    }

    public ReplicationEvent withAssetPath(String assetPath) {
        this.assetPath = assetPath;
        return this;
    }

    public ReplicationEvent withStatus(Status status) {
        this.status = status;
        return this;
    }

    public ReplicationEvent withReplicationConnectionId(String replicationConnectionId) {
        this.replicationConnectionId = replicationConnectionId;
        return this;
    }

    public ReplicationEvent withNode(String node) {
        this.node = node;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationEvent that = (ReplicationEvent)o;
        return this.id == that.id && this.repositoryName.equals(that.repositoryName) && this.type == that.type && this.assetPath.equals(that.assetPath) && this.status == that.status && this.replicationConnectionId.equals(that.replicationConnectionId) && Objects.equals(this.node, that.node);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.repositoryName, this.type, this.assetPath, this.status, this.replicationConnectionId, this.node});
    }

    public String toString() {
        return "ReplicationEvent{id=" + this.id + ", repositoryName='" + this.repositoryName + '\'' + ", type=" + (Object)((Object)this.type) + ", assetPath='" + this.assetPath + '\'' + ", status=" + (Object)((Object)this.status) + ", replicationConnectionId='" + this.replicationConnectionId + '\'' + ", node='" + this.node + '\'' + '}';
    }

    public static enum Status {
        READY,
        IN_USE,
        FAILED;

    }

    public static enum Type {
        ADD,
        DELETE;

    }
}

