/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication.db.datastore.upgrade;

import java.sql.Connection;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.upgrade.datastore.DatabaseMigrationStep;

@Named
@Singleton
public class ReplicationUpgrade_1_8
extends ComponentSupport
implements DatabaseMigrationStep {
    private static String REPLICATION = "replication_connection";

    public Optional<String> version() {
        return Optional.of("1.8");
    }

    public void migrate(Connection connection) throws Exception {
        if (!this.tableExists(connection, REPLICATION)) {
            this.log.warn("Table replication_connection doesn't exist, upgrade step ReplicationUpgrade_1_0 will be skipped");
            return;
        }
        this.log.info("Adding use_trust_store column to replication_connection table");
        this.runStatement(connection, "ALTER TABLE replication_connection ADD COLUMN IF NOT EXISTS use_trust_store BOOLEAN NOT NULL DEFAULT FALSE");
    }
}

