/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication;

import com.sonatype.nexus.replication.ReplicationConnectionManager;
import com.sonatype.nexus.replication.ReplicationDuplicateException;
import com.sonatype.nexus.replication.db.model.ReplicationConnection;
import com.sonatype.nexus.replication.db.model.ReplicationConnectionImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.supportzip.ExportConfigData;
import org.sonatype.nexus.supportzip.ImportTaskData;
import org.sonatype.nexus.supportzip.datastore.JsonExporter;

@Named(value="replicationConnectionExport")
@Singleton
public class ReplicationConnectionExport
extends JsonExporter
implements ExportConfigData,
ImportTaskData {
    private final ReplicationConnectionManager connectionManager;

    @Inject
    public ReplicationConnectionExport(ReplicationConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void export(File file) throws IOException {
        this.log.debug("Export Replication Connection data to {}", (Object)file);
        Collection<ReplicationConnection> connections = this.connectionManager.list();
        this.exportToJson(new ArrayList<ReplicationConnection>(connections), file);
    }

    public void restore(File file) throws IOException {
        this.log.debug("Restoring Replication Connection data from {}", (Object)file);
        this.importFromJson(file, ReplicationConnectionImpl.class).forEach(connection -> {
            try {
                this.connectionManager.create((ReplicationConnection)connection);
            }
            catch (ReplicationDuplicateException e) {
                this.log.error("Couldn't restore duplicate replication connection {}", connection, (Object)e);
            }
        });
    }
}

