/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.replication;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.replication.internal.pull.SourceConnection;
import com.sonatype.nexus.replication.internal.pull.SourceInstanceConnector;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.ConstraintViolation;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.app.FeatureFlagGroup;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.manager.ConfigurationValidator;
import org.sonatype.nexus.validation.ConstraintViolationFactory;

@Named
@FeatureFlagGroup(value={@FeatureFlag(name="nexus.datastore.enabled"), @FeatureFlag(name="nexus.replication.http.enabled")})
public class ReplicationConfigurationValidator
extends ComponentSupport
implements ConfigurationValidator {
    private final ConstraintViolationFactory constraintViolationFactory;
    private final SourceInstanceConnector sourceInstanceConnector;
    private static final String REPLICATION_KEY = "replication";

    @Inject
    public ReplicationConfigurationValidator(ConstraintViolationFactory constraintViolationFactory, SourceInstanceConnector sourceInstanceConnector) {
        this.constraintViolationFactory = (ConstraintViolationFactory)Preconditions.checkNotNull((Object)constraintViolationFactory);
        this.sourceInstanceConnector = sourceInstanceConnector;
    }

    @Nullable
    public ConstraintViolation<?> validate(Configuration configuration) {
        Map replicationAttributes;
        if (configuration == null) {
            return null;
        }
        Map attributes = configuration.getAttributes();
        if (attributes == null) {
            return null;
        }
        Map proxyAttributes = (Map)attributes.get("proxy");
        if (proxyAttributes != null && proxyAttributes.containsKey("remoteUrl") && (replicationAttributes = (Map)attributes.get(REPLICATION_KEY)) != null && Boolean.TRUE.equals(replicationAttributes.get("preemptivePullEnabled"))) {
            return this.validateReplication(configuration, (String)proxyAttributes.get("remoteUrl"));
        }
        return null;
    }

    @VisibleForTesting
    ConstraintViolation<?> validateReplication(Configuration configuration, String remoteUrl) {
        boolean validEndpoint = false;
        Optional<SourceConnection> connection = SourceConnection.from(configuration);
        if (connection.isPresent()) {
            validEndpoint = this.sourceInstanceConnector.validateSuitableRemote(connection.get());
        }
        if (!validEndpoint) {
            return this.constraintViolationFactory.createViolation(REPLICATION_KEY, String.format("The Remote endpoint %s does not appear to be a Nexus Hosted Repository", remoteUrl));
        }
        return null;
    }
}

