/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.r.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sonatype.nexus.blobstore.restore.r.internal.orient.OrientRRestoreBlobData;
import com.sonatype.nexus.repository.r.orient.OrientRRestoreFacet;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.util.StringUtils;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.restore.RestoreBlobData;
import org.sonatype.nexus.blobstore.restore.orient.OrientBaseRestoreBlobStrategy;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Query;

@Named(value="r")
@Singleton
public class OrientRRestoreBlobStrategy
extends OrientBaseRestoreBlobStrategy<OrientRRestoreBlobData> {
    @Inject
    public OrientRRestoreBlobStrategy(NodeAccess nodeAccess, RepositoryManager repositoryManager, BlobStoreManager blobStoreManager, DryRunPrefix dryRunPrefix) {
        super(nodeAccess, repositoryManager, blobStoreManager, dryRunPrefix);
    }

    protected OrientRRestoreBlobData createRestoreData(RestoreBlobData restoreBlobData) {
        Preconditions.checkState((!StringUtils.isEmpty((String)restoreBlobData.getBlobName()) ? 1 : 0) != 0, (Object)"Blob name cannot be empty");
        return new OrientRRestoreBlobData(restoreBlobData);
    }

    protected boolean canAttemptRestore(@Nonnull OrientRRestoreBlobData rRestoreBlobData) {
        Repository repository = this.getRepository(rRestoreBlobData);
        Optional rRestoreFacetFacet = repository.optionalFacet(OrientRRestoreFacet.class);
        if (!rRestoreFacetFacet.isPresent()) {
            this.log.warn("Skipping as R Restore Facet not found on repository: {}", (Object)repository.getName());
            return false;
        }
        return true;
    }

    protected String getAssetPath(@Nonnull OrientRRestoreBlobData rRestoreBlobData) {
        return rRestoreBlobData.getBlobData().getBlobName();
    }

    protected boolean assetExists(@Nonnull OrientRRestoreBlobData rRestoreBlobData) {
        OrientRRestoreFacet facet = this.getRestoreFacet(rRestoreBlobData);
        return facet.assetExists(this.getAssetPath(rRestoreBlobData));
    }

    protected void createAssetFromBlob(@Nonnull AssetBlob assetBlob, @Nonnull OrientRRestoreBlobData rRestoreBlobData) throws IOException {
        OrientRRestoreFacet facet = this.getRestoreFacet(rRestoreBlobData);
        String path = this.getAssetPath(rRestoreBlobData);
        facet.restore(assetBlob, path);
    }

    @Nonnull
    protected List<HashAlgorithm> getHashAlgorithms() {
        return ImmutableList.of((Object)HashAlgorithm.SHA1);
    }

    protected boolean componentRequired(OrientRRestoreBlobData data) {
        OrientRRestoreFacet facet = this.getRestoreFacet(data);
        String path = data.getBlobData().getBlobName();
        return facet.componentRequired(path);
    }

    protected Query getComponentQuery(OrientRRestoreBlobData data) throws IOException {
        Map attributes;
        OrientRRestoreFacet facet = this.getRestoreFacet(data);
        RestoreBlobData blobData = data.getBlobData();
        Throwable throwable = null;
        Object var6_6 = null;
        try (InputStream inputStream = blobData.getBlob().getInputStream();){
            attributes = facet.extractComponentAttributesFromArchive(blobData.getBlobName(), inputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return facet.getComponentQuery(attributes);
    }

    protected Repository getRepository(@Nonnull OrientRRestoreBlobData data) {
        return data.getBlobData().getRepository();
    }

    private OrientRRestoreFacet getRestoreFacet(@Nonnull OrientRRestoreBlobData rRestoreBlobData) {
        Repository repository = this.getRepository(rRestoreBlobData);
        return (OrientRRestoreFacet)repository.facet(OrientRRestoreFacet.class);
    }
}

