/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.internal.orient;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.blobstore.restore.internal.YumUtils;
import com.sonatype.nexus.blobstore.restore.internal.orient.YumRestoreBlobData;
import javax.annotation.Nonnull;
import org.eclipse.aether.util.StringUtils;
import org.sonatype.nexus.blobstore.restore.RestoreBlobData;
import org.sonatype.nexus.repository.proxy.ProxyFacet;
import org.sonatype.nexus.repository.yum.AssetKind;

public final class YumRestoreBlobDataFactory {
    public YumRestoreBlobData create(@Nonnull RestoreBlobData data) {
        Preconditions.checkState((!StringUtils.isEmpty((String)data.getBlobName()) ? 1 : 0) != 0, (Object)"Blob name cannot be empty");
        AssetKind assetKind = YumUtils.parseAssetKind(data.getBlobName());
        if (data.getRepository().optionalFacet(ProxyFacet.class).isPresent() && assetKind == AssetKind.COMPS) {
            assetKind = AssetKind.REPODATA;
        }
        return new YumRestoreBlobData(data.getBlobName(), assetKind, data);
    }
}

