/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.internal.datastore;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.blobstore.restore.internal.YumUtils;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.restore.datastore.BaseRestoreBlobStrategy;
import org.sonatype.nexus.blobstore.restore.datastore.DataStoreRestoreBlobData;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.DetachedBlobPayload;
import org.sonatype.nexus.repository.yum.datastore.YumContentFacet;

@Named(value="yum")
@Singleton
public class YumRestoreBlobStrategy
extends BaseRestoreBlobStrategy<DataStoreRestoreBlobData> {
    private final RepositoryManager repositoryManager;

    @Inject
    public YumRestoreBlobStrategy(DryRunPrefix dryRunPrefix, RepositoryManager repositoryManager) {
        super(dryRunPrefix);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    protected boolean canAttemptRestore(@Nonnull DataStoreRestoreBlobData data) {
        Repository repository = data.getRepository();
        if (!repository.optionalFacet(ContentFacet.class).isPresent()) {
            this.log.warn("Skipping as Content Facet not found on repository: {}", (Object)repository.getName());
            return false;
        }
        return true;
    }

    protected void createAssetFromBlob(Blob assetBlob, DataStoreRestoreBlobData data) {
        YumContentFacet yumFacet = (YumContentFacet)data.getRepository().facet(YumContentFacet.class);
        String blobName = data.getBlobName();
        yumFacet.put(blobName, (Payload)new DetachedBlobPayload(assetBlob), YumUtils.parseAssetKind(blobName));
    }

    protected String getAssetPath(@Nonnull DataStoreRestoreBlobData data) {
        return data.getBlobName();
    }

    protected DataStoreRestoreBlobData createRestoreData(Properties properties, Blob blob, BlobStore blobStore) {
        return new DataStoreRestoreBlobData(blob, properties, blobStore, this.repositoryManager);
    }

    protected boolean isComponentRequired(DataStoreRestoreBlobData data) {
        String blobName = data.getBlobName();
        return Pattern.compile(".*[dD]?[rR][pP][mM]$").matcher(blobName).find();
    }

    public void after(boolean updateAssets, Repository repository) {
    }
}

