/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.internal;

import com.google.common.base.Preconditions;
import org.sonatype.nexus.repository.yum.AssetKind;
import org.sonatype.nexus.repository.yum.utils.YumPathUtils;

public final class YumUtils {
    private YumUtils() {
    }

    public static AssetKind parseAssetKind(String blobName) {
        Preconditions.checkNotNull((Object)blobName);
        if (YumPathUtils.REPOMD_ASC_MATCHER.matcher(blobName).matches()) {
            return AssetKind.REPOMD_ASC;
        }
        if (YumPathUtils.REPOMD_MATCHER.matcher(blobName).matches()) {
            return AssetKind.REPOMD;
        }
        if (YumPathUtils.COMPS_MATCHER.matcher(blobName).matches()) {
            return AssetKind.COMPS;
        }
        if (YumPathUtils.MODULES_MATCHER.matcher(blobName).matches()) {
            return AssetKind.MODULES;
        }
        if (YumPathUtils.REPODATA_MATCHER.matcher(blobName).matches()) {
            return AssetKind.REPODATA;
        }
        if (YumPathUtils.RPM_MATCHER.matcher(blobName).matches()) {
            return AssetKind.RPM;
        }
        return AssetKind.NON_YUM;
    }
}

