/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.datastore.internal;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.datastore.DataStoreRestorer;
import org.sonatype.nexus.datastore.api.DataStoreConfiguration;

@Named(value="default")
@Singleton
public class DataStoreRestorerLocalImpl
extends ComponentSupport
implements DataStoreRestorer {
    private final ApplicationDirectories applicationDirectories;

    @Inject
    public DataStoreRestorerLocalImpl(ApplicationDirectories applicationDirectories) {
        this.applicationDirectories = (ApplicationDirectories)Preconditions.checkNotNull((Object)applicationDirectories);
    }

    @Override
    public boolean maybeRestore(DataStoreConfiguration dataStoreConfiguration) {
        File dbDirectory = this.getDbDirectory();
        File restoreDirectory = this.getRestoreDirectory();
        if (!restoreDirectory.exists()) {
            this.log.debug("Restore directory does not exist, skipping.");
            return false;
        }
        return this.doRestore(dbDirectory, restoreDirectory, dataStoreConfiguration);
    }

    private boolean doRestore(File dbDirectory, File restoreDirectory, DataStoreConfiguration dataStoreConfiguration) {
        if (!dbDirectory.exists() && !dbDirectory.mkdirs()) {
            this.log.error("Unable to restore from backup");
            throw new RuntimeException("Unable to create database directory: " + dbDirectory.getAbsolutePath());
        }
        String dataStoreFileName = dataStoreConfiguration.getName().concat(".mv.db");
        Path dbPath = dbDirectory.toPath();
        if (dbPath.resolve(dataStoreFileName).toFile().exists()) {
            this.log.debug("Data store '{}' exists, skipping.", (Object)dataStoreFileName);
            return false;
        }
        File[] files = restoreDirectory.listFiles();
        if (files == null) {
            this.log.debug("Could not list files in restore directory '{}', skipping.", (Object)restoreDirectory.getAbsolutePath());
            return false;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File backup = fileArray[n2];
            this.log.info("Checking for backup of '{}' in '{}'", (Object)dataStoreFileName, (Object)backup.getAbsolutePath());
            if (this.restore(dbPath, backup, dataStoreFileName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean restore(Path dbDirectory, File backupArchive, String dataStoreFileName) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ZipFile zip = new ZipFile(backupArchive);){
                return zip.stream().filter(entry -> entry.getName().equals(dataStoreFileName)).findFirst().map(entry -> {
                    try {
                        Files.copy(zip.getInputStream((ZipEntry)entry), dbDirectory.resolve(entry.getName()), new CopyOption[0]);
                        this.log.info("Restored {}", (Object)entry.getName());
                        return true;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to extract " + entry.getName() + " from archive: " + backupArchive.getAbsolutePath(), e);
                    }
                }).orElse(false);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to open archive: " + backupArchive.getAbsolutePath(), e);
        }
    }

    private File getDbDirectory() {
        return this.applicationDirectories.getWorkDirectory("db");
    }

    private File getRestoreDirectory() {
        return this.applicationDirectories.getWorkDirectory("restore-from-backup");
    }
}

