/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.datastore;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Function;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.datastore.DataStoreConfigurationSource;
import org.sonatype.nexus.datastore.api.DataStoreConfiguration;

@Named
@Singleton
public class DataStoreConfigurationManager
extends ComponentSupport {
    private final Map<String, DataStoreConfigurationSource> configurationSources;

    @Inject
    public DataStoreConfigurationManager(Map<String, DataStoreConfigurationSource> configurationSources) {
        this.configurationSources = (Map)Preconditions.checkNotNull(configurationSources);
    }

    public Iterable<DataStoreConfiguration> load() {
        TreeSet configuredStores = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        return (Iterable)this.configurationSources.values().stream().filter(DataStoreConfigurationSource::isEnabled).sorted(Comparator.comparingInt(this::getPriority).reversed()).flatMap(source -> Streams.stream(source.browseStoreNames()).filter(configuredStores::add).map(this.configLoader((DataStoreConfigurationSource)source))).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
    }

    private int getPriority(DataStoreConfigurationSource configSource) {
        if (configSource.getClass().isAnnotationPresent(Priority.class)) {
            Priority priority = configSource.getClass().getAnnotation(Priority.class);
            return priority.value();
        }
        this.log.warn("Loaded config source {} without priority, assuming last", (Object)configSource.getName());
        return Integer.MIN_VALUE;
    }

    public void save(DataStoreConfiguration configuration) {
        this.findModifiableSource(configuration).save(configuration);
    }

    public void delete(DataStoreConfiguration configuration) {
        this.findModifiableSource(configuration).delete(configuration);
    }

    private Function<String, DataStoreConfiguration> configLoader(DataStoreConfigurationSource source) {
        return storeName -> {
            try {
                return source.load((String)storeName);
            }
            catch (RuntimeException e) {
                this.log.warn("Problem reading configuration of data store {} from {}", new Object[]{storeName, source, e});
                return null;
            }
        };
    }

    private DataStoreConfigurationSource findModifiableSource(DataStoreConfiguration configuration) {
        DataStoreConfigurationSource source = this.configurationSources.get(configuration.getSource());
        Preconditions.checkArgument((source != null ? 1 : 0) != 0, (String)"%s refers to a missing source", (Object)configuration);
        Preconditions.checkArgument((boolean)source.isModifiable(), (String)"%s is from a read-only source", (Object)configuration);
        return source;
    }
}

