/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.datastore;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import javax.annotation.Priority;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.datastore.DataStoreConfigurationSource;
import org.sonatype.nexus.datastore.api.DataStoreConfiguration;

@Named(value="local")
@Priority(value=-2147483648)
@Singleton
public class DataStoreConfigurationDefaultSource
extends ComponentSupport
implements DataStoreConfigurationSource {
    static final String LOCAL = "local";
    private static final String JDBC_TEMPLATE_URL = "jdbc:h2:file:${karaf.data}/db/nexus";
    private static final String JDBC = "jdbc";
    private static final String JDBC_URL = "jdbcUrl";

    @Override
    public String getName() {
        return "Local";
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public Iterable<String> browseStoreNames() {
        return ImmutableSet.builder().add((Object)"nexus").build();
    }

    @Override
    public DataStoreConfiguration load(String storeName) {
        Preconditions.checkArgument((boolean)"nexus".equalsIgnoreCase(storeName), (String)"%s is not valid, %s is the only valid data store name", (Object)storeName, (Object)"nexus");
        DataStoreConfiguration configuration = new DataStoreConfiguration();
        configuration.setName("nexus");
        configuration.setType(JDBC);
        configuration.setSource(LOCAL);
        configuration.setAttributes((Map)ImmutableMap.of((Object)JDBC_URL, (Object)JDBC_TEMPLATE_URL));
        this.log.info("Loaded '{}' data store configuration defaults (Embedded H2)", (Object)storeName);
        return configuration;
    }
}

