/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.datastore;

import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import org.eclipse.sisu.inject.TypeArguments;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.datastore.api.DataAccess;
import org.sonatype.nexus.datastore.api.DataSession;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.transaction.TransactionalStore;
import org.sonatype.nexus.transaction.UnitOfWork;

public abstract class ConfigStoreSupport<T extends DataAccess>
extends StateGuardLifecycleSupport
implements TransactionalStore<DataSession<?>> {
    protected final DataSessionSupplier sessionSupplier;
    private final Class<T> daoClass;

    protected ConfigStoreSupport(DataSessionSupplier sessionSupplier) {
        this.sessionSupplier = (DataSessionSupplier)Preconditions.checkNotNull((Object)sessionSupplier);
        TypeLiteral superType = TypeLiteral.get(((Object)((Object)this)).getClass()).getSupertype(ConfigStoreSupport.class);
        this.daoClass = TypeArguments.get((TypeLiteral)superType, (int)0).getRawType();
    }

    protected ConfigStoreSupport(DataSessionSupplier sessionSupplier, Class<T> daoClass) {
        this.sessionSupplier = (DataSessionSupplier)Preconditions.checkNotNull((Object)sessionSupplier);
        this.daoClass = (Class)Preconditions.checkNotNull(daoClass);
    }

    protected DataSession<?> thisSession() {
        return (DataSession)UnitOfWork.currentSession();
    }

    protected T dao() {
        return (T)this.thisSession().access(this.daoClass);
    }

    public DataSession<?> openSession() {
        return this.sessionSupplier.openSession("nexus");
    }
}

