/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.utils;

import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.yum.AssetKind;
import org.sonatype.nexus.repository.yum.internal.utils.YumMetadataUtils;

public class YumFacetUtils {
    private YumFacetUtils() {
    }

    public static HashAlgorithm hashAlgorithmByName(String name) {
        if ("sha".equals(name)) {
            return HashAlgorithm.SHA1;
        }
        for (HashAlgorithm hashAlgorithm : YumMetadataUtils.HASH_ALGORITHMS) {
            if (!hashAlgorithm.name().equals(name)) continue;
            return hashAlgorithm;
        }
        throw new IllegalArgumentException("Unsupported hash " + name);
    }

    public static boolean isPrimary(String assetPath, AssetKind assetKind) {
        return assetKind.equals((Object)AssetKind.REPODATA) && assetPath.substring(assetPath.indexOf(47) + 1).toLowerCase().contains("primary");
    }
}

