/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.sonatype.nexus.common.io.SafeXml;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.w3c.dom.Document;

public abstract class TempBlobConverter {
    private final DocumentBuilderFactory documentBuilderFactory = SafeXml.newdocumentBuilderFactory();
    private final TransformerFactory transformerFactory;

    public TempBlobConverter() throws ParserConfigurationException {
        this.documentBuilderFactory.setValidating(false);
        this.transformerFactory = SafeXml.newTransformerFactory();
    }

    public Document toDocument(TempBlob blob) throws Exception {
        DocumentBuilder builder = this.documentBuilderFactory.newDocumentBuilder();
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream is = blob.get();){
            return builder.parse(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public TempBlob toTempBlob(Document document, Repository repository) throws TransformerException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DOMSource xmlSource = new DOMSource(document);
        StreamResult outputTarget = new StreamResult(outputStream);
        this.transformerFactory.newTransformer().transform(xmlSource, outputTarget);
        ByteArrayInputStream is = new ByteArrayInputStream(outputStream.toByteArray());
        return this.toTempBlob(is, repository);
    }

    public abstract TempBlob toTempBlob(InputStream var1, Repository var2);
}

