/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.orient.internal.upload;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.hash.HashAlgorithmHelper;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.InvalidContentException;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.importtask.ImportFileConfiguration;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.OrientHardLinkHelper;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.upload.AssetUpload;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StreamPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.repository.yum.AssetKind;
import org.sonatype.nexus.repository.yum.DeployPolicy;
import org.sonatype.nexus.repository.yum.internal.YumUploadHandlerSupport;
import org.sonatype.nexus.repository.yum.internal.utils.AssetKindUtils;
import org.sonatype.nexus.repository.yum.internal.utils.YumMetadataUtils;
import org.sonatype.nexus.repository.yum.orient.OrientYumFacet;
import org.sonatype.nexus.repository.yum.orient.internal.hosted.OrientYumHostedFacet;
import org.sonatype.nexus.rest.ValidationErrorsException;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named(value="yum")
@Singleton
public class OrientYumUploadHandler
extends YumUploadHandlerSupport {
    private final OrientHardLinkHelper hardLinkHelper;
    private final HashAlgorithmHelper hashAlgorithmHelper;

    @Inject
    public OrientYumUploadHandler(ContentPermissionChecker contentPermissionChecker, @Named(value="simple") VariableResolverAdapter variableResolverAdapter, Set<UploadDefinitionExtension> uploadDefinitionExtensions, OrientHardLinkHelper hardLinkHelper, HashAlgorithmHelper hashAlgorithmHelper) {
        super(uploadDefinitionExtensions, variableResolverAdapter, contentPermissionChecker);
        this.hardLinkHelper = (OrientHardLinkHelper)Preconditions.checkNotNull((Object)hardLinkHelper);
        this.hashAlgorithmHelper = (HashAlgorithmHelper)Preconditions.checkNotNull((Object)hashAlgorithmHelper);
    }

    public UploadResponse handle(Repository repository, ComponentUpload upload) throws IOException {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)upload);
        OrientYumHostedFacet yumHostedFacet = (OrientYumHostedFacet)repository.facet(OrientYumHostedFacet.class);
        OrientYumUploadHandler.validateRepository(yumHostedFacet, upload);
        AssetUpload assetUpload = (AssetUpload)upload.getAssetUploads().get(0);
        String assetPath = OrientYumUploadHandler.getAssetPath(upload);
        this.ensurePermitted(repository.getName(), "yum", assetPath, Collections.emptyMap());
        try {
            UnitOfWork.begin((Supplier)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier());
            yumHostedFacet.upload(assetPath, (Payload)assetUpload.getPayload(), OrientYumUploadHandler.detectKind(assetUpload));
            Asset asset = ((OrientYumFacet)repository.facet(OrientYumFacet.class)).getAsset(assetPath);
            UploadResponse uploadResponse = new UploadResponse(asset);
            return uploadResponse;
        }
        finally {
            UnitOfWork.end();
        }
    }

    private static AssetKind detectKind(AssetUpload assetUpload) {
        String fileName = assetUpload.getField("filename");
        return AssetKindUtils.detectKindByName(fileName);
    }

    @VisibleForTesting
    static String getAssetPath(ComponentUpload upload) {
        String assetPath = YumUploadHandlerSupport.buildAssetPath(upload);
        if (assetPath.charAt(0) == '/') {
            return assetPath.substring(1);
        }
        return assetPath;
    }

    private static void validateRepository(OrientYumHostedFacet yumHostedFacet, ComponentUpload upload) {
        AssetUpload assetUpload = (AssetUpload)upload.getAssetUploads().get(0);
        String filename = assetUpload.getField("filename");
        if (!AssetKindUtils.isRpm(filename) && !AssetKindUtils.isComps(filename)) {
            OrientYumUploadHandler.validatePermissiveDeployPolicy(yumHostedFacet);
        }
        if (AssetKindUtils.isRpm(filename)) {
            OrientYumUploadHandler.validateRepodataDepth(yumHostedFacet, OrientYumUploadHandler.getAssetPath(upload));
        }
    }

    private static void validateRepodataDepth(OrientYumHostedFacet yumHostedFacet, String path) {
        try {
            yumHostedFacet.validateRepodataDepth(path);
        }
        catch (InvalidContentException e) {
            throw new ValidationErrorsException(e.getMessage());
        }
    }

    private static void validatePermissiveDeployPolicy(OrientYumHostedFacet yumHostedFacet) {
        if (yumHostedFacet.getDeployPolicy() == DeployPolicy.STRICT) {
            throw new ValidationErrorsException("Uploading non-rpm files is unsupported in strict repositories.");
        }
    }

    public boolean supportsExportImport() {
        return true;
    }

    public Content handle(Repository repository, File content, String path) throws IOException {
        return this.handle(new ImportFileConfiguration(repository, content, path, false));
    }

    public Content handle(ImportFileConfiguration configuration) throws IOException {
        String assetName = configuration.getAssetName();
        this.ensurePermitted(configuration.getRepository().getName(), "yum", assetName, Collections.emptyMap());
        OrientYumHostedFacet yumHostedFacet = (OrientYumHostedFacet)configuration.getRepository().facet(OrientYumHostedFacet.class);
        AssetKind assetKind = AssetKindUtils.detectKindByName(configuration.getFile().getName());
        if (AssetKind.RPM == assetKind) {
            OrientYumUploadHandler.validateRepodataDepth(yumHostedFacet, assetName);
        } else {
            assetKind = AssetKindUtils.detectKindByPath(assetName);
            OrientYumUploadHandler.validatePermissiveDeployPolicy(yumHostedFacet);
        }
        if (configuration.isHardLinkingEnabled()) {
            return this.handleImportHardLink(configuration, assetKind);
        }
        return this.handleImport(configuration, assetKind);
    }

    private Content handleImportHardLink(ImportFileConfiguration configuration, AssetKind assetKind) throws IOException {
        Repository repository = configuration.getRepository();
        String path = configuration.getAssetName();
        File content = configuration.getFile();
        OrientYumHostedFacet yumHostedFacet = (OrientYumHostedFacet)repository.facet(OrientYumHostedFacet.class);
        Map hashAlgorithmHashCodeMap = this.hashAlgorithmHelper.calculateChecksums(content, YumMetadataUtils.HASH_ALGORITHMS);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        AssetBlob assetBlob = this.hardLinkHelper.ingestHardLink(tx, content, hashAlgorithmHashCodeMap);
        if (assetKind == AssetKind.RPM) {
            return yumHostedFacet.putRpmHardLink(path, assetBlob);
        }
        return yumHostedFacet.putMetadataHardLink(path, assetBlob, assetKind);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Content handleImport(ImportFileConfiguration configuration, AssetKind assetKind) throws IOException {
        Repository repository = configuration.getRepository();
        String path = configuration.getAssetName();
        File content = configuration.getFile();
        OrientYumHostedFacet yumHostedFacet = (OrientYumHostedFacet)repository.facet(OrientYumHostedFacet.class);
        StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
        this.ensurePermitted(repository.getName(), "yum", path, Collections.emptyMap());
        String contentType = Files.probeContentType(content.toPath());
        Throwable throwable = null;
        Object var10_11 = null;
        try (StreamPayload payload = new StreamPayload(() -> new BufferedInputStream(new FileInputStream(content)), content.length(), contentType);){
            switch (assetKind) {
                case REPOMD: 
                case REPOMD_ASC: 
                case REPODATA: {
                    Throwable throwable2 = null;
                    Object var13_16 = null;
                    TempBlob tempBlob = storageFacet.createTempBlob((Payload)payload, YumMetadataUtils.HASH_ALGORITHMS);
                    Content content2 = yumHostedFacet.putMetadata(path, (InputStreamSupplier)tempBlob, contentType, assetKind);
                    if (tempBlob == null) return content2;
                    tempBlob.close();
                    return content2;
                    {
                        catch (Throwable throwable3) {
                            try {
                                if (tempBlob == null) throw throwable3;
                                tempBlob.close();
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (throwable2 == null) {
                                    throwable2 = throwable4;
                                    throw throwable2;
                                } else {
                                    if (throwable2 == throwable4) throw throwable2;
                                    throwable2.addSuppressed(throwable4);
                                }
                                throw throwable2;
                            }
                        }
                    }
                }
            }
            return yumHostedFacet.upload(path, (Payload)payload, assetKind);
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            } else {
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }
}

