/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.orient.internal.search;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.search.ComponentMetadataProducerExtension;
import org.sonatype.nexus.repository.search.DefaultComponentMetadataProducer;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.yum.AssetKind;

@Singleton
@Named(value="yum")
public class OrientYumComponentMetadataProducer
extends DefaultComponentMetadataProducer {
    private static final List<String> preReleaseMap = ImmutableList.of((Object)"alpha", (Object)"beta", (Object)"rc", (Object)"pre", (Object)"prerelease", (Object)"snapshot");

    @Inject
    public OrientYumComponentMetadataProducer(Set<ComponentMetadataProducerExtension> componentMetadataProducerExtensions) {
        super(componentMetadataProducerExtensions);
    }

    protected boolean isPrerelease(Component component, Iterable<Asset> assets) {
        List rpmList = Streams.stream(assets).filter(this::isRpm).collect(Collectors.toList());
        if (rpmList.isEmpty()) {
            return false;
        }
        return rpmList.stream().filter(asset -> asset.formatAttributes().contains("release")).map(asset -> (String)asset.formatAttributes().get("release")).allMatch(this::containsPrereleaseSignature);
    }

    private boolean containsPrereleaseSignature(String str) {
        return preReleaseMap.stream().anyMatch(preRelease -> Strings2.lower((String)str).contains(Strings2.lower((String)preRelease)));
    }

    private boolean isRpm(Asset asset) {
        return asset.formatAttributes().contains("asset_kind") && asset.formatAttributes().get("asset_kind").equals(AssetKind.RPM.name());
    }
}

