/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.orient.internal.hosted;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.IllegalOperationException;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentMaintenance;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.storage.WritePolicySelector;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchMetadata;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.repository.yum.AssetKind;
import org.sonatype.nexus.repository.yum.internal.YumHostedFacetSupport;
import org.sonatype.nexus.repository.yum.internal.utils.YumMetadataUtils;
import org.sonatype.nexus.repository.yum.orient.OrientYumFacet;
import org.sonatype.nexus.repository.yum.orient.internal.database.OrientYumQueryComponent;
import org.sonatype.nexus.repository.yum.orient.internal.hosted.OrientYumHostedFacet;
import org.sonatype.nexus.repository.yum.orient.internal.hosted.OrientYumHostedWritePolicySelector;
import org.sonatype.nexus.repository.yum.orient.internal.utils.OrientYumFacetUtils;
import org.sonatype.nexus.repository.yum.utils.YumPathUtils;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class OrientYumHostedFacetImpl
extends YumHostedFacetSupport
implements OrientYumHostedFacet {
    private final OrientYumQueryComponent orientYumQueryComponent;
    private OrientYumFacet yumFacet;

    @Inject
    public OrientYumHostedFacetImpl(OrientYumQueryComponent orientYumQueryComponent) {
        this.orientYumQueryComponent = (OrientYumQueryComponent)((Object)Preconditions.checkNotNull((Object)((Object)orientYumQueryComponent)));
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.yumFacet = (OrientYumFacet)this.facet(OrientYumFacet.class);
        ((StorageFacet)this.getRepository().facet(StorageFacet.class)).registerWritePolicySelector((WritePolicySelector)new OrientYumHostedWritePolicySelector());
    }

    @Override
    @Nullable
    @TransactionalTouchBlob
    public Content get(String path) {
        Preconditions.checkNotNull((Object)path);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        this.log.debug("Getting {}", (Object)path);
        Asset asset = this.orientYumQueryComponent.findAsset(tx, tx.findBucket(this.getRepository()), path);
        if (asset == null) {
            return null;
        }
        return OrientYumFacetUtils.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
    }

    @Override
    public Content upload(String path, Payload payload, AssetKind assetKind) throws IOException {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)payload);
        if (assetKind != AssetKind.RPM && assetKind != AssetKind.COMPS && assetKind != AssetKind.NON_YUM) {
            throw new IllegalArgumentException("Unsupported assetKind: " + (Object)((Object)assetKind));
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = ((StorageFacet)this.facet(StorageFacet.class)).createTempBlob(payload, YumMetadataUtils.HASH_ALGORITHMS);){
            if (assetKind == AssetKind.RPM) {
                this.validateRepodataDepth(path);
                return this.yumFacet.storeRpm(path, (InputStreamSupplier)tempBlob, payload);
            }
            if (assetKind == AssetKind.COMPS) {
                return this.putMetadata(path, (InputStreamSupplier)tempBlob, payload.getContentType(), AssetKind.COMPS);
            }
            if (assetKind == AssetKind.NON_YUM) {
                return this.putNonYumFile(path, tempBlob, payload);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }

    @Override
    @TransactionalStoreBlob
    public Content putRpmHardLink(String path, AssetBlob assetBlob) throws IOException {
        this.validateRepodataDepth(path);
        return this.yumFacet.storeRpm(path, assetBlob);
    }

    @Override
    @TransactionalTouchBlob
    public Blob getBlob(Supplier<StorageTx> txSupplier, BlobRef blobRef) {
        return txSupplier.get().getBlob(blobRef);
    }

    @Override
    @TransactionalTouchBlob
    public Blob requireBlob(Supplier<StorageTx> txSupplier, BlobRef blobRef) {
        return txSupplier.get().requireBlob(blobRef);
    }

    @Override
    @TransactionalTouchBlob
    public boolean assetExists(Supplier<StorageTx> txSupplier, String path, Repository repository) {
        return txSupplier.get().assetExists(path, repository);
    }

    @Override
    @TransactionalStoreBlob
    public Content putMetadataHardLink(String path, AssetBlob assetBlob, AssetKind assetKind) {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = this.orientYumQueryComponent.findAsset(tx, bucket = tx.findBucket(this.getRepository()), path);
        if (asset == null) {
            asset = tx.createAsset(bucket, this.getRepository().getFormat());
            asset.name(path);
            asset.formatAttributes().set("asset_kind", (Object)assetKind.name());
        }
        tx.attachBlob(asset, assetBlob);
        return this.yumFacet.saveAsset(tx, asset, assetBlob, null);
    }

    @Override
    @TransactionalStoreBlob
    public Content putMetadata(String path, InputStreamSupplier content, String contentType, AssetKind assetKind) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        return this.doPutMetadata(path, content, contentType, assetKind, tx, bucket);
    }

    @TransactionalStoreBlob
    protected Content putNonYumFile(String path, TempBlob tempBlob, Payload payload) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset asset = this.yumFacet.findOrCreateAsset(path, AssetKind.NON_YUM, new AttributesMap(), tx, bucket);
        return this.yumFacet.saveAsset(tx, asset, (InputStreamSupplier)tempBlob, payload);
    }

    @Override
    @TransactionalDeleteBlob
    public boolean delete(String path) {
        Preconditions.checkNotNull((Object)path);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset asset = this.orientYumQueryComponent.findAsset(tx, bucket, path);
        this.log.debug("Deleting {}", (Object)path);
        if (asset == null) {
            return false;
        }
        if (this.isMetadata(asset)) {
            throw new IllegalOperationException("Deletion of metadata forbidden");
        }
        ((ComponentMaintenance)this.facet(ComponentMaintenance.class)).deleteAsset(asset.getEntityMetadata().getId());
        return true;
    }

    private boolean isMetadata(Asset asset) {
        String assetKind = (String)asset.formatAttributes().get("asset_kind", String.class);
        return Objects.equals(AssetKind.REPODATA.name(), assetKind) || Objects.equals(AssetKind.REPOMD.name(), assetKind) || Objects.equals(AssetKind.REPOMD_ASC.name(), assetKind);
    }

    @Override
    @TransactionalDeleteBlob
    public void delete(List<String> paths) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        for (String path : paths) {
            Asset asset = this.orientYumQueryComponent.findAsset(tx, bucket, path);
            if (asset == null) continue;
            tx.deleteAsset(asset);
        }
    }

    @Override
    @TransactionalTouchMetadata
    public List<Asset> getMetadataFilesToDelete(List<String> directories, String ... excluding) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        List<String> excludeList = Arrays.asList(excluding);
        return StreamSupport.stream(this.orientYumQueryComponent.findRepodataAssets(tx, this.getRepository()).spliterator(), false).filter(asset -> !excludeList.contains(asset.name())).filter(asset -> this.matchesDirectory(directories, (Asset)asset)).collect(Collectors.toList());
    }

    private boolean matchesDirectory(List<String> directories, Asset asset) {
        return directories.isEmpty() || directories.contains(YumPathUtils.extractDirectoryFromMetadataPath(asset.name()));
    }

    @Override
    @TransactionalDeleteBlob
    public void deleteRepomdIfNoRpmsLeft(@Nullable String directory) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        long count = this.orientYumQueryComponent.countRpmsInDirectory(directory, tx, this.getRepository());
        if (count == 0L) {
            this.orientYumQueryComponent.findRepomdOnPath(tx, this.getRepository(), directory).forEach(arg_0 -> ((StorageTx)tx).deleteAsset(arg_0));
        }
    }

    @Override
    @TransactionalDeleteBlob
    public void deleteRepodataIfNoRpmsLeft(@Nullable String directory) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        long count = this.orientYumQueryComponent.countRpmsInDirectory(directory, tx, this.getRepository());
        if (count == 0L) {
            this.orientYumQueryComponent.findRepodataAssetsOnPath(() -> tx, this.getRepository(), directory).forEach(arg_0 -> ((StorageTx)tx).deleteAsset(arg_0));
        }
    }

    @Override
    @TransactionalStoreMetadata
    public void metadataGenerationStarted(long at) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        bucket.attributes().set("metadata_generation_time", (Object)at);
        tx.saveBucket(bucket);
    }

    @Override
    @TransactionalTouchMetadata
    public long getMetadataGenerationStartedTime() {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        if (bucket.attributes().contains("metadata_generation_time")) {
            return (Long)bucket.attributes().get("metadata_generation_time", Long.class);
        }
        return 0L;
    }

    @Override
    @TransactionalStoreMetadata
    public void setRpmsRemovedFlagIfCountChanged(String folder, long expectedRpmCount) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        long count = this.orientYumQueryComponent.countRpmsInDirectory(folder, tx, this.getRepository());
        this.log.debug("Rpm count is {}", (Object)count);
        this.markMetadataAsRpmsRemoved(folder, tx, count < expectedRpmCount);
    }

    @Override
    public void markMetadataAsRpmsRemoved(String location, StorageTx tx, boolean removed) {
        Integer repodataDepth = this.getRepodataDepth();
        String directory = YumPathUtils.extractDirectoryAtDepth(location, repodataDepth).orElse("");
        Iterable<Asset> metadata = this.orientYumQueryComponent.findRepomdOnPath(tx, this.getRepository(), directory);
        for (Asset metadataAsset : metadata) {
            if (removed) {
                this.log.debug("Setting {} to true for repomd in {}:{}", new Object[]{"rpms_removed", this.getRepository().getName(), directory});
                metadataAsset.formatAttributes().set("rpms_removed", (Object)true);
            } else {
                this.log.debug("Removing {} from repomd in {}:{}", new Object[]{"rpms_removed", this.getRepository().getName(), directory});
                metadataAsset.formatAttributes().remove("rpms_removed");
            }
            tx.saveAsset(metadataAsset);
        }
    }

    @Override
    @TransactionalTouchBlob
    public void markMetadataAsRpmsRemovedInNewTx(String location, Supplier<StorageTx> tx, boolean removed) {
        this.markMetadataAsRpmsRemoved(location, tx.get(), removed);
    }

    @Override
    public Integer getComponentDepth(Component component) {
        return this.getPathDepth(this.firstAssetFor(this.getRepository(), component).name());
    }

    protected Asset firstAssetFor(Repository repository, Component component) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (StorageTx tx = (StorageTx)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier().get();){
            tx.begin();
            Iterator i = tx.browseAssets(component).iterator();
            Asset asset = i.hasNext() ? (Asset)i.next() : null;
            return asset;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected Content doPutMetadata(String path, InputStreamSupplier content, String contentType, AssetKind assetKind, StorageTx tx, Bucket bucket) throws IOException {
        Asset asset = this.orientYumQueryComponent.findAsset(tx, bucket, path);
        if (asset == null) {
            asset = tx.createAsset(bucket, this.getRepository().getFormat());
            asset.name(path);
            asset.formatAttributes().set("asset_kind", (Object)assetKind.name());
        }
        return this.yumFacet.saveAsset(tx, asset, content, contentType, new AttributesMap());
    }
}

