/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.orient.internal.hosted;

import java.util.Collections;
import java.util.Set;
import javax.inject.Named;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.DefaultComponentMaintenanceImpl;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.repository.yum.orient.internal.hosted.OrientYumHostedFacet;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class OrientYumHostedComponentMaintenanceFacet
extends DefaultComponentMaintenanceImpl {
    @TransactionalDeleteBlob
    protected DefaultComponentMaintenanceImpl.DeletionResult deleteComponentTx(EntityId componentId, boolean deleteBlobs) {
        DefaultComponentMaintenanceImpl.DeletionResult deletionResult = super.deleteComponentTx(componentId, deleteBlobs);
        deletionResult.getAssets().forEach(asset -> ((OrientYumHostedFacet)this.facet(OrientYumHostedFacet.class)).markMetadataAsRpmsRemoved((String)asset, (StorageTx)UnitOfWork.currentTx(), true));
        return deletionResult;
    }

    public Set<String> deleteAsset(EntityId assetId) {
        return (Set)Transactional.operation.withDb(((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier()).call(() -> this.deleteAssetTx(assetId, true));
    }

    protected Set<String> deleteAssetTx(EntityId assetId, boolean deleteBlob) {
        Component component;
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = tx.findAsset(assetId, bucket = tx.findBucket(this.getRepository()));
        if (asset == null) {
            return Collections.emptySet();
        }
        this.log.info("Deleting asset: {}", (Object)asset);
        tx.deleteAsset(asset, deleteBlob);
        OrientYumHostedFacet hostedFacet = (OrientYumHostedFacet)this.facet(OrientYumHostedFacet.class);
        hostedFacet.markMetadataAsRpmsRemoved(asset.name(), tx, true);
        if (asset.componentId() != null && !tx.browseAssets(component = tx.findComponentInBucket(asset.componentId(), bucket)).iterator().hasNext()) {
            this.log.debug("Deleting component: {}", (Object)component);
            tx.deleteComponent(component, deleteBlob);
        }
        return Collections.singleton(asset.name());
    }
}

