/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.orient.internal.hosted;

import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.IllegalOperationException;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.yum.AssetKind;
import org.sonatype.nexus.repository.yum.DeployPolicy;
import org.sonatype.nexus.repository.yum.orient.internal.hosted.OrientYumHostedFacet;
import org.sonatype.nexus.repository.yum.utils.YumPathUtils;

@Named
@Singleton
public class OrientHostedHandlers
extends ComponentSupport {
    public final Handler get = context -> {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String path = YumPathUtils.buildAssetPath(state);
        Content content = ((OrientYumHostedFacet)context.getRepository().facet(OrientYumHostedFacet.class)).get(path);
        return content != null ? HttpResponses.ok((Payload)content) : HttpResponses.notFound();
    };
    public final Handler upload = context -> {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String path = YumPathUtils.buildAssetPath(state);
        AssetKind assetKind = (AssetKind)((Object)((Object)context.getAttributes().require(AssetKind.class)));
        ((OrientYumHostedFacet)context.getRepository().facet(OrientYumHostedFacet.class)).upload(path, context.getRequest().getPayload(), assetKind);
        return HttpResponses.ok();
    };
    public final Handler delete = context -> {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String path = (String)state.getTokens().get("name");
        return this.deleteByPath(context, path);
    };
    public final Handler handleNonYumFile = context -> {
        String method = context.getRequest().getAction();
        OrientYumHostedFacet hosted = (OrientYumHostedFacet)context.getRepository().facet(OrientYumHostedFacet.class);
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String name = (String)state.getTokens().get("name");
        switch (method) {
            case "GET": 
            case "HEAD": {
                return this.getNonYumFile(hosted, name);
            }
            case "PUT": {
                return this.uploadNonYumFile(name, context, hosted);
            }
        }
        return HttpResponses.methodNotAllowed((String)method, (String[])new String[]{"GET", "HEAD", "PUT"});
    };

    private Response deleteByPath(Context context, String path) {
        boolean deleted;
        try {
            deleted = ((OrientYumHostedFacet)context.getRepository().facet(OrientYumHostedFacet.class)).delete(path);
        }
        catch (IllegalOperationException illegalOperationException) {
            this.log.warn("Deletion {} is prohibited", (Object)path);
            return HttpResponses.methodNotAllowed((String)context.getRequest().getAction(), (String[])new String[]{"DELETE"});
        }
        if (!deleted) {
            return HttpResponses.notFound();
        }
        return HttpResponses.ok();
    }

    private Response getNonYumFile(OrientYumHostedFacet hosted, String name) {
        Content content = hosted.get(name);
        if (content == null) {
            return HttpResponses.notFound((String)name);
        }
        return HttpResponses.ok((Payload)content);
    }

    private Response uploadNonYumFile(String name, Context context, OrientYumHostedFacet hosted) throws IOException {
        if (hosted.getDeployPolicy() == DeployPolicy.STRICT) {
            throw new IllegalOperationException("Invalid path for a Yum repository");
        }
        Preconditions.checkState((name != null ? 1 : 0) != 0, (Object)"Missing token: name");
        hosted.upload(name, context.getRequest().getPayload(), AssetKind.NON_YUM);
        return HttpResponses.ok();
    }
}

