/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.orient.internal.group;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Objects;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.manager.RepositoryUpdatedEvent;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetDeletedEvent;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupRepomdInvalidatorFacet;
import org.sonatype.nexus.repository.yum.orient.internal.database.OrientYumQueryComponent;
import org.sonatype.nexus.repository.yum.utils.YumPathUtils;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Facet.Exposed
public class OrientYumGroupRepomdInvalidatorFacetImpl
extends FacetSupport
implements YumGroupRepomdInvalidatorFacet {
    private final OrientYumQueryComponent orientYumQueryComponent;

    @Inject
    public OrientYumGroupRepomdInvalidatorFacetImpl(OrientYumQueryComponent orientYumQueryComponent) {
        this.orientYumQueryComponent = (OrientYumQueryComponent)((Object)Preconditions.checkNotNull((Object)((Object)orientYumQueryComponent)));
    }

    @Override
    @TransactionalStoreBlob
    public void markRepomdAssetsToInvalidateCache() {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        this.orientYumQueryComponent.findRepomdOnPath(tx, this.getRepository(), null).forEach(asset -> {
            asset.formatAttributes().set("cache_invalid", (Object)true);
            tx.saveAsset(asset);
        });
    }

    @Override
    @TransactionalStoreBlob
    public void markRepomdAssetToUseCache(String path) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        String repomdPath = YumPathUtils.getRepomdPath(path);
        Asset asset = this.orientYumQueryComponent.findAsset(tx, tx.findBucket(this.getRepository()), repomdPath);
        if (Objects.nonNull(asset)) {
            asset.formatAttributes().remove("cache_invalid");
            tx.saveAsset(asset);
        }
    }

    @Override
    @TransactionalStoreBlob
    public void markRepomdAssetToInvalidateCache(String assetPath) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = this.orientYumQueryComponent.findAsset(tx, tx.findBucket(this.getRepository()), assetPath);
        if (Objects.nonNull(asset)) {
            asset.formatAttributes().set("cache_invalid", (Object)true);
            tx.saveAsset(asset);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    protected void on(AssetDeletedEvent event) {
        if (this.isRelevantRepomdDeleteEvent(event)) {
            Repository repository = this.getRepository();
            String assetPath = event.getAsset().name();
            UnitOfWork.begin((Supplier)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier());
            try {
                this.log.debug("Asset {} of Repository {} was deleted. Group Repository {} asset will be marked to have invalid cache.", new Object[]{assetPath, event.getRepositoryName(), repository.getName()});
                this.markRepomdAssetToInvalidateCache(assetPath);
            }
            finally {
                UnitOfWork.end();
            }
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    protected void on(RepositoryUpdatedEvent event) {
        Repository repository = event.getRepository();
        if (this.isYumGroupRepository(repository)) {
            UnitOfWork.begin((Supplier)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier());
            try {
                this.log.debug("Repository {} was updated. Marking Repomds to have invalid cache.", (Object)repository.getName());
                this.markRepomdAssetsToInvalidateCache();
            }
            finally {
                UnitOfWork.end();
            }
        }
    }

    private boolean isYumGroupRepository(Repository repository) {
        return "group".equals(repository.getType().getValue()) && "yum".equals(repository.getFormat().getValue());
    }

    private boolean isRelevantRepomdDeleteEvent(AssetDeletedEvent event) {
        return event.isLocal() && event.getComponentId() == null && event.getAsset().name().endsWith("repodata/repomd.xml") && ((GroupFacet)this.facet(GroupFacet.class)).member(event.getRepositoryName());
    }
}

